/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.base.Objects;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.MethodInvocationMatcherCollection;
import org.sonar.java.checks.methods.MethodMatcher;
import org.sonar.java.checks.methods.TypeCriteria;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2970", name="Assertions should be complete", tags={"junit"}, priority=Priority.CRITICAL)
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNIT_TESTABILITY")
@SqaleConstantRemediation(value="5min")
public class AssertionsCompletenessCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final MethodMatcher MOCKITO_VERIFY = MethodMatcher.create().typeDefinition("org.mockito.Mockito").name("verify").withNoParameterConstraint();
    private static final MethodInvocationMatcherCollection FEST_ASSERT_THAT = MethodInvocationMatcherCollection.create(MethodMatcher.create().typeDefinition("org.fest.assertions.Assertions").name("assertThat").addParameter(TypeCriteria.anyType()), MethodMatcher.create().typeDefinition("org.fest.assertions.api.Assertions").name("assertThat").addParameter(TypeCriteria.anyType()));
    private static final MethodInvocationMatcherCollection FEST_EXCLUSIONS = MethodInvocationMatcherCollection.create(MethodMatcher.create().typeDefinition(TypeCriteria.anyType()).name("as").withNoParameterConstraint(), MethodMatcher.create().typeDefinition(TypeCriteria.anyType()).name("describedAs").withNoParameterConstraint(), MethodMatcher.create().typeDefinition(TypeCriteria.anyType()).name("overridingErrorMessage").withNoParameterConstraint());
    private Boolean chainedToAnyMethodButFestExclusions = null;
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitVariable(VariableTree tree) {
    }

    public void visitReturnStatement(ReturnStatementTree tree) {
    }

    public void visitMethodInvocation(MethodInvocationTree mit) {
        if (this.incompleteAssertion(mit)) {
            return;
        }
        Boolean previous = this.chainedToAnyMethodButFestExclusions;
        this.chainedToAnyMethodButFestExclusions = (Boolean)Objects.firstNonNull((Object)this.chainedToAnyMethodButFestExclusions, (Object)false) != false || !FEST_EXCLUSIONS.anyMatch(mit);
        this.scan((Tree)mit.methodSelect());
        this.chainedToAnyMethodButFestExclusions = previous;
    }

    private boolean incompleteAssertion(MethodInvocationTree mit) {
        if ((FEST_ASSERT_THAT.anyMatch(mit) && mit.arguments().size() == 1 || MOCKITO_VERIFY.matches(mit)) && !Boolean.TRUE.equals(this.chainedToAnyMethodButFestExclusions)) {
            this.context.addIssue((Tree)mit, (JavaCheck)this, "Complete the assertion.");
            return true;
        }
        return false;
    }
}

