/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayDeque;
import java.util.Deque;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.MethodInvocationMatcherCollection;
import org.sonar.java.checks.methods.MethodMatcher;
import org.sonar.java.checks.methods.NameCriteria;
import org.sonar.java.checks.methods.TypeCriteria;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2699", name="Tests should include assertions", tags={"junit"}, priority=Priority.CRITICAL)
@SqaleSubCharacteristic(value="UNIT_TESTABILITY")
@SqaleConstantRemediation(value="10min")
public class AssertionsInTestsCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final MethodMatcher MOCKITO_VERIFY = MethodMatcher.create().typeDefinition("org.mockito.Mockito").name("verify").withNoParameterConstraint();
    private static final MethodMatcher ASSERT_THAT = MethodMatcher.create().typeDefinition(TypeCriteria.anyType()).name("assertThat").addParameter(TypeCriteria.anyType());
    private static final MethodMatcher FEST_AS_METHOD = MethodMatcher.create().typeDefinition(TypeCriteria.anyType()).name("as").withNoParameterConstraint();
    private static final MethodMatcher FEST_DESCRIBED_AS_METHOD = MethodMatcher.create().typeDefinition(TypeCriteria.anyType()).name("describedAs").withNoParameterConstraint();
    private static final MethodMatcher FEST_OVERRIDE_ERROR_METHOD = MethodMatcher.create().typeDefinition(TypeCriteria.anyType()).name("overridingErrorMessage").withNoParameterConstraint();
    private static final MethodInvocationMatcherCollection ASSERTION_INVOCATION_MATCHERS = MethodInvocationMatcherCollection.create(MethodMatcher.create().typeDefinition("org.junit.Assert").name(NameCriteria.startsWith("assert")).withNoParameterConstraint(), MethodMatcher.create().typeDefinition("org.junit.Assert").name("fail").withNoParameterConstraint(), MethodMatcher.create().typeDefinition("org.junit.rules.ExpectedException").name(NameCriteria.startsWith("expect")).withNoParameterConstraint(), MethodMatcher.create().typeDefinition("junit.framework.Assert").name(NameCriteria.startsWith("assert")).withNoParameterConstraint(), MethodMatcher.create().typeDefinition("junit.framework.Assert").name(NameCriteria.startsWith("fail")).withNoParameterConstraint(), MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf("org.fest.assertions.GenericAssert")).name(NameCriteria.any()).withNoParameterConstraint(), MethodMatcher.create().typeDefinition("org.fest.assertions.Fail").name(NameCriteria.startsWith("fail")).withNoParameterConstraint(), MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf("org.fest.assertions.api.AbstractAssert")).name(NameCriteria.any()).withNoParameterConstraint(), MethodMatcher.create().typeDefinition("org.fest.assertions.api.Fail").name(NameCriteria.startsWith("fail")).withNoParameterConstraint(), MethodMatcher.create().typeDefinition("org.mockito.Mockito").name("verifyNoMoreInteractions").withNoParameterConstraint());
    private final Deque<Boolean> methodContainsAssertion = new ArrayDeque<Boolean>();
    private final Deque<Boolean> inUnitTest = new ArrayDeque<Boolean>();
    private final Deque<ChainedMethods> chainedTo = new ArrayDeque<ChainedMethods>();
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitMethod(MethodTree methodTree) {
        boolean isUnitTest = AssertionsInTestsCheck.isUnitTest(methodTree);
        this.inUnitTest.push(isUnitTest);
        this.methodContainsAssertion.push(false);
        super.visitMethod(methodTree);
        this.inUnitTest.pop();
        Boolean containsAssertion = this.methodContainsAssertion.pop();
        if (isUnitTest && !containsAssertion.booleanValue()) {
            this.context.addIssue((Tree)methodTree, (JavaCheck)this, "Add at least one assertion to this test case.");
        }
    }

    public void visitMethodInvocation(MethodInvocationTree mit) {
        if (this.inUnitTest.isEmpty() || !this.inUnitTest.peek().booleanValue() || this.methodContainsAssertion.peek().booleanValue()) {
            return;
        }
        this.chainedTo.push(ChainedMethods.NONE);
        super.visitMethodInvocation(mit);
        ChainedMethods chainedToResult = this.chainedTo.pop();
        if (AssertionsInTestsCheck.containsAssertion(mit, chainedToResult)) {
            this.methodContainsAssertion.pop();
            this.methodContainsAssertion.push(Boolean.TRUE);
        }
        if (!this.chainedTo.isEmpty()) {
            if (ChainedMethods.ASSERT_THAT.equals((Object)chainedToResult) || ASSERT_THAT.matches(mit)) {
                this.chainedTo.pop();
                this.chainedTo.push(ChainedMethods.ASSERT_THAT);
            } else if (MOCKITO_VERIFY.matches(mit)) {
                this.chainedTo.pop();
                this.chainedTo.push(ChainedMethods.MOCKITO_VERIFY);
            }
        }
    }

    private static boolean containsAssertion(MethodInvocationTree mit, ChainedMethods chainedToResult) {
        boolean isChainedToAssertThatWithBadResolution = ChainedMethods.ASSERT_THAT.equals((Object)chainedToResult) && mit.symbol().isUnknown();
        boolean isChainedToVerify = ChainedMethods.MOCKITO_VERIFY.equals((Object)chainedToResult);
        return isChainedToVerify || isChainedToAssertThatWithBadResolution || AssertionsInTestsCheck.isAssertion(mit);
    }

    private static boolean isAssertion(MethodInvocationTree mit) {
        return ASSERTION_INVOCATION_MATCHERS.anyMatch(mit) && !FEST_AS_METHOD.matches(mit) && !FEST_OVERRIDE_ERROR_METHOD.matches(mit) && !FEST_DESCRIBED_AS_METHOD.matches(mit);
    }

    private static boolean isUnitTest(MethodTree methodTree) {
        if (methodTree.symbol().metadata().isAnnotatedWith("org.junit.Test")) {
            return true;
        }
        Symbol.TypeSymbol enclosingClass = methodTree.symbol().enclosingClass();
        return enclosingClass != null && enclosingClass.type().isSubtypeOf("junit.framework.TestCase") && methodTree.simpleName().name().startsWith("test");
    }

    private static enum ChainedMethods {
        NONE,
        ASSERT_THAT,
        MOCKITO_VERIFY;

    }
}

