/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.apache.commons.lang.StringUtils;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.bytecode.asm.AsmClass;
import org.sonar.java.bytecode.asm.AsmEdge;
import org.sonar.java.bytecode.asm.AsmMethod;
import org.sonar.java.bytecode.visitor.BytecodeVisitor;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CheckMessage;
import org.sonar.squidbridge.api.SourceFile;

@Rule(key="CallToDeprecatedMethod", name="Avoid use of deprecated methods", tags={"cwe", "obsolete", "owasp-a9", "security"}, priority=Priority.MINOR)
@SqaleSubCharacteristic(value="SOFTWARE_RELATED_PORTABILITY")
@SqaleConstantRemediation(value="15min")
public class CallToDeprecatedMethodCheck
extends BytecodeVisitor {
    private AsmClass asmClass;

    public void visitClass(AsmClass asmClass) {
        this.asmClass = asmClass;
    }

    public void visitEdge(AsmEdge edge) {
        if (edge.getTo().isDeprecated() && edge.getTo() instanceof AsmMethod) {
            AsmMethod targetMethod = (AsmMethod)edge.getTo();
            SourceFile sourceFile = this.getSourceFile(this.asmClass);
            CheckMessage message = new CheckMessage((Object)this, this.formatMessage(targetMethod), new Object[0]);
            message.setLine(edge.getSourceLineNumber());
            sourceFile.log(message);
        }
    }

    public String formatMessage(AsmMethod asmMethod) {
        if (asmMethod.isConstructor()) {
            return "Constructor '" + this.getShortClassName(asmMethod.getParent()) + "(...)' is deprecated.";
        }
        return "Method '" + this.getShortClassName(asmMethod.getParent()) + "." + asmMethod.getName() + "(...)' is deprecated.";
    }

    public String getShortClassName(AsmClass asmClass) {
        return StringUtils.substringAfterLast((String)asmClass.getInternalName(), (String)"/");
    }
}

