/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ParameterizedTypeTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2440", name="Classes with only \"static\" methods should not be instantiated", tags={"clumsy"}, priority=Priority.MAJOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="2min")
public class ClassWithOnlyStaticMethodsInstantiationCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.NEW_CLASS);
    }

    public void visitNode(Tree tree) {
        TypeTree identifier = ((NewClassTree)tree).identifier();
        Symbol.TypeSymbol newClassTypeSymbol = identifier.symbolType().symbol();
        if (!newClassTypeSymbol.isEnum() && ClassWithOnlyStaticMethodsInstantiationCheck.hasOnlyStaticMethods(newClassTypeSymbol) && !this.instantiateOwnClass((Tree)identifier, newClassTypeSymbol)) {
            String message = "Remove this instantiation.";
            String name = ClassWithOnlyStaticMethodsInstantiationCheck.getNewClassName((Tree)identifier);
            if (name != null) {
                message = "Remove this instantiation of \"{0}\".";
            }
            this.addIssue(tree, MessageFormat.format(message, name));
        }
    }

    private boolean instantiateOwnClass(Tree identifier, Symbol.TypeSymbol newClassTypeSymbol) {
        Type enclosingClassType = this.getSemanticModel().getEnclosingClass(identifier).type();
        return enclosingClassType.equals(newClassTypeSymbol.type());
    }

    private static boolean hasOnlyStaticMethods(Symbol.TypeSymbol newClassTypeSymbol) {
        Collection<Symbol.MethodSymbol> methods = ClassWithOnlyStaticMethodsInstantiationCheck.filterMethods(newClassTypeSymbol.memberSymbols());
        if (methods.isEmpty()) {
            return false;
        }
        for (Symbol.MethodSymbol method : methods) {
            if (method.isStatic()) continue;
            return false;
        }
        return ClassWithOnlyStaticMethodsInstantiationCheck.superClassHasOnlyStaticMethods(newClassTypeSymbol);
    }

    private static boolean superClassHasOnlyStaticMethods(Symbol.TypeSymbol newClassTypeSymbol) {
        Type superClass = newClassTypeSymbol.superClass();
        if (superClass != null && !superClass.is("java.lang.Object")) {
            return ClassWithOnlyStaticMethodsInstantiationCheck.hasOnlyStaticMethods(superClass.symbol());
        }
        return true;
    }

    private static Collection<Symbol.MethodSymbol> filterMethods(Collection<Symbol> symbols) {
        ArrayList methods = Lists.newArrayList();
        for (Symbol symbol : symbols) {
            if (!symbol.isMethodSymbol() || ClassWithOnlyStaticMethodsInstantiationCheck.isConstructor(symbol)) continue;
            methods.add((Symbol.MethodSymbol)symbol);
        }
        return methods;
    }

    private static boolean isConstructor(Symbol symbol) {
        return "<init>".equals(symbol.name());
    }

    @Nullable
    private static String getNewClassName(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            return ((IdentifierTree)tree).name();
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            return ((MemberSelectExpressionTree)tree).identifier().name();
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.PARAMETERIZED_TYPE})) {
            return ClassWithOnlyStaticMethodsInstantiationCheck.getNewClassName((Tree)((ParameterizedTypeTree)tree).type());
        }
        return null;
    }
}

