/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.AbstractDeprecatedChecker;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1133", name="Deprecated code should be removed eventually", tags={"obsolete"}, priority=Priority.INFO)
@ActivatedByDefault
@SqaleSubCharacteristic(value="ARCHITECTURE_CHANGEABILITY")
@SqaleConstantRemediation(value="10min")
public class DeprecatedTagPresenceCheck
extends AbstractDeprecatedChecker {
    public void visitNode(Tree tree) {
        if (DeprecatedTagPresenceCheck.hasDeprecatedAnnotation(tree) || DeprecatedTagPresenceCheck.hasJavadocDeprecatedTag(tree)) {
            this.addIssue(tree, "Do not forget to remove this deprecated code someday.");
        }
    }
}

