/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.MethodMatcher;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ParenthesizedTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2976", name="\"File.createTempFile\" should not be used to create a directory", tags={"owasp-a9", "security"}, priority=Priority.CRITICAL)
@ActivatedByDefault
@SqaleSubCharacteristic(value="API_ABUSE")
@SqaleConstantRemediation(value="5min")
public class FileCreateTempFileCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final String JAVA_IO_FILE = "java.io.File";
    private static final MethodMatcher FILE_CREATE_TEMP_FILE = MethodMatcher.create().typeDefinition("java.io.File").name("createTempFile").withNoParameterConstraint();
    private static final MethodMatcher FILE_DELETE = MethodMatcher.create().typeDefinition("java.io.File").name("delete");
    private static final MethodMatcher FILE_MKDIR = MethodMatcher.create().typeDefinition("java.io.File").name("mkdir");
    private final Deque<Map<Symbol, State>> symbolStack = new LinkedList<Map<Symbol, State>>();
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitMethod(MethodTree tree) {
        this.symbolStack.push(new HashMap());
        super.visitMethod(tree);
        this.symbolStack.pop();
    }

    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        ExpressionTree variable;
        super.visitAssignmentExpression(tree);
        if (FileCreateTempFileCheck.isFileCreateTempFile(tree.expression()) && (variable = tree.variable()).is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && !this.symbolStack.isEmpty()) {
            this.symbolStack.peek().put(((IdentifierTree)variable).symbol(), State.CREATE_TMP_FILE);
        }
    }

    public void visitVariable(VariableTree tree) {
        super.visitVariable(tree);
        ExpressionTree initializer = tree.initializer();
        if (initializer != null && FileCreateTempFileCheck.isFileCreateTempFile(initializer)) {
            Symbol symbol = tree.symbol();
            if (!this.symbolStack.isEmpty()) {
                this.symbolStack.peek().put(symbol, State.CREATE_TMP_FILE);
            }
        }
    }

    private static boolean isFileCreateTempFile(ExpressionTree givenExpression) {
        ExpressionTree expressionTree = FileCreateTempFileCheck.removeParenthesis(givenExpression);
        return expressionTree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && FILE_CREATE_TEMP_FILE.matches((MethodInvocationTree)expressionTree);
    }

    public void visitMethodInvocation(MethodInvocationTree mit) {
        super.visitMethodInvocation(mit);
        if (FILE_DELETE.matches(mit)) {
            this.checkAndAdvanceState(mit, State.CREATE_TMP_FILE, State.DELETE);
        } else if (FILE_MKDIR.matches(mit) && State.MKDIR.equals((Object)this.checkAndAdvanceState(mit, State.DELETE, State.MKDIR))) {
            this.context.addIssue((Tree)mit, (JavaCheck)this, "Use \"Files.createTempDirectory\" or a library function to create this directory instead.");
        }
    }

    @Nullable
    private State checkAndAdvanceState(MethodInvocationTree mit, State requiredState, State nextState) {
        ExpressionTree expressionTree;
        ExpressionTree methodSelect = mit.methodSelect();
        if (methodSelect.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && (expressionTree = ((MemberSelectExpressionTree)methodSelect).expression()).is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            Symbol symbol = ((IdentifierTree)expressionTree).symbol();
            Map<Symbol, State> symbolStateMap = this.symbolStack.peek();
            if (symbolStateMap != null && symbolStateMap.containsKey(symbol) && requiredState.equals((Object)symbolStateMap.get(symbol))) {
                symbolStateMap.put(symbol, nextState);
                return nextState;
            }
        }
        return null;
    }

    private static ExpressionTree removeParenthesis(ExpressionTree tree) {
        ExpressionTree result = tree;
        while (result.is(new Tree.Kind[]{Tree.Kind.PARENTHESIZED_EXPRESSION})) {
            result = ((ParenthesizedTree)result).expression();
        }
        return result;
    }

    private static enum State {
        CREATE_TMP_FILE,
        DELETE,
        MKDIR;

    }
}

