/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.java.syntaxtoken.FirstSyntaxTokenFinder;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="HiddenFieldCheck", name="Local variables should not shadow class fields", tags={"pitfall"}, priority=Priority.MAJOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="DATA_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class HiddenFieldCheck
extends SubscriptionBaseVisitor {
    private final Deque<ImmutableMap<String, VariableTree>> fields = Lists.newLinkedList();
    private final Deque<List<VariableTree>> excludedVariables = Lists.newLinkedList();
    private final List<VariableTree> flattenExcludedVariables = Lists.newArrayList();

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS, (Object)Tree.Kind.ENUM, (Object)Tree.Kind.INTERFACE, (Object)Tree.Kind.ANNOTATION_TYPE, (Object)Tree.Kind.VARIABLE, (Object)Tree.Kind.METHOD, (Object)Tree.Kind.CONSTRUCTOR, (Object)Tree.Kind.STATIC_INITIALIZER);
    }

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.fields.clear();
        this.excludedVariables.clear();
        this.flattenExcludedVariables.clear();
        super.scanFile(context);
    }

    public void visitNode(Tree tree) {
        if (HiddenFieldCheck.isClassTree(tree)) {
            ClassTree classTree = (ClassTree)tree;
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Tree member : classTree.members()) {
                if (!member.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) continue;
                VariableTree variableTree = (VariableTree)member;
                builder.put((Object)variableTree.simpleName().name(), (Object)variableTree);
            }
            this.fields.push((ImmutableMap<String, VariableTree>)builder.build());
            this.excludedVariables.push(Lists.newArrayList());
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
            VariableTree variableTree = (VariableTree)tree;
            this.isVariableHidingField(variableTree);
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.STATIC_INITIALIZER})) {
            this.excludeVariablesFromBlock((BlockTree)tree);
        } else {
            MethodTree methodTree = (MethodTree)tree;
            this.excludedVariables.peek().addAll(methodTree.parameters());
            this.flattenExcludedVariables.addAll(methodTree.parameters());
            if (ModifiersUtils.hasModifier((ModifiersTree)methodTree.modifiers(), (Modifier)Modifier.STATIC)) {
                this.excludeVariablesFromBlock(methodTree.block());
            }
        }
    }

    private void isVariableHidingField(VariableTree variableTree) {
        for (ImmutableMap<String, VariableTree> variables : this.fields) {
            if (variables.values().contains((Object)variableTree)) {
                return;
            }
            String identifier = variableTree.simpleName().name();
            VariableTree hiddenVariable = (VariableTree)variables.get((Object)identifier);
            if (this.flattenExcludedVariables.contains(variableTree) || hiddenVariable == null) continue;
            int line = FirstSyntaxTokenFinder.firstSyntaxToken((Tree)hiddenVariable).line();
            this.addIssue((Tree)variableTree, "Rename \"" + identifier + "\" which hides the field declared at line " + line + ".");
            return;
        }
    }

    private static boolean isClassTree(Tree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.CLASS}) || tree.is(new Tree.Kind[]{Tree.Kind.ENUM}) || tree.is(new Tree.Kind[]{Tree.Kind.INTERFACE}) || tree.is(new Tree.Kind[]{Tree.Kind.ANNOTATION_TYPE});
    }

    public void leaveNode(Tree tree) {
        if (HiddenFieldCheck.isClassTree(tree)) {
            this.fields.pop();
            this.flattenExcludedVariables.removeAll((Collection)this.excludedVariables.pop());
        }
    }

    private void excludeVariablesFromBlock(@Nullable BlockTree blockTree) {
        if (blockTree != null) {
            List<VariableTree> variableTrees = new VariableList().scan((Tree)blockTree);
            this.excludedVariables.peek().addAll(variableTrees);
            this.flattenExcludedVariables.addAll(variableTrees);
        }
    }

    private static class VariableList {
        private List<VariableTree> variables;
        private List<Tree.Kind> visitNodes;
        private List<Tree.Kind> excludedNodes;

        private VariableList() {
        }

        List<VariableTree> scan(Tree tree) {
            this.visitNodes = this.nodesToVisit();
            this.excludedNodes = this.excludedNodes();
            this.variables = Lists.newArrayList();
            this.visit(tree);
            return this.variables;
        }

        public List<Tree.Kind> nodesToVisit() {
            return ImmutableList.of((Object)Tree.Kind.VARIABLE);
        }

        public List<Tree.Kind> excludedNodes() {
            return ImmutableList.of((Object)Tree.Kind.METHOD, (Object)Tree.Kind.CLASS, (Object)Tree.Kind.ENUM, (Object)Tree.Kind.INTERFACE, (Object)Tree.Kind.NEW_CLASS);
        }

        private void visit(Tree tree) {
            if (this.isSubscribed(tree)) {
                this.variables.add((VariableTree)tree);
            }
            this.visitChildren(tree);
        }

        private void visitChildren(Tree tree) {
            JavaTree javaTree = (JavaTree)tree;
            if (!javaTree.isLeaf()) {
                Iterator iter = javaTree.childrenIterator();
                while (iter.hasNext()) {
                    Tree next = (Tree)iter.next();
                    if (next == null || this.isExcluded(next)) continue;
                    this.visit(next);
                }
            }
        }

        private boolean isSubscribed(Tree tree) {
            return this.visitNodes.contains(((JavaTree)tree).getKind());
        }

        private boolean isExcluded(Tree tree) {
            return this.excludedNodes.contains(((JavaTree)tree).getKind());
        }
    }
}

