/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.text.MessageFormat;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2386", name="Interfaces should not have \"public static\" mutable fields", tags={"unpredictable"}, priority=Priority.CRITICAL)
@ActivatedByDefault
@SqaleSubCharacteristic(value="DATA_RELIABILITY")
@SqaleConstantRemediation(value="30min")
public class InterfaceStaticMutableMemberCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.INTERFACE);
    }

    public void visitNode(Tree tree) {
        for (Tree member : ((ClassTree)tree).members()) {
            VariableTree variableTree;
            if (!member.is(new Tree.Kind[]{Tree.Kind.VARIABLE}) || !InterfaceStaticMutableMemberCheck.isStaticMember(variableTree = (VariableTree)member) || !InterfaceStaticMutableMemberCheck.isMutableMember(variableTree)) continue;
            this.addIssue((Tree)variableTree, MessageFormat.format("Move \"{0}\" to a class and lower its visibility", variableTree.simpleName().name()));
        }
    }

    private static boolean isStaticMember(VariableTree variableTree) {
        return ModifiersUtils.hasModifier((ModifiersTree)variableTree.modifiers(), (Modifier)Modifier.STATIC);
    }

    private static boolean isMutableMember(VariableTree variableTree) {
        return InterfaceStaticMutableMemberCheck.isArray((Tree)variableTree.type()) || InterfaceStaticMutableMemberCheck.isDateOrCollection(variableTree.type().symbolType());
    }

    private static boolean isArray(Tree typeTree) {
        return typeTree.is(new Tree.Kind[]{Tree.Kind.ARRAY_TYPE});
    }

    private static boolean isDateOrCollection(Type variableSymbolType) {
        return variableSymbolType.is("java.util.Date") || variableSymbolType.isSubtypeOf("java.util.Collection") && !variableSymbolType.isSubtypeOf("com.google.common.collect.ImmutableCollection");
    }
}

