/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.EnumConstantTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S109", name="Magic numbers should not be used", tags={"brain-overload"}, priority=Priority.MINOR)
@SqaleSubCharacteristic(value="DATA_CHANGEABILITY")
@SqaleConstantRemediation(value="5min")
public class MagicNumberCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitEnumConstant(EnumConstantTree tree) {
        this.scan((Tree)tree.initializer().classBody());
    }

    public void visitLiteral(LiteralTree tree) {
        if (MagicNumberCheck.isNumberLiteral(tree)) {
            DecimalFormat decimalFormat = new DecimalFormat();
            decimalFormat.setParseBigDecimal(true);
            BigDecimal checked = null;
            try {
                checked = (BigDecimal)decimalFormat.parse(tree.value());
            }
            catch (ParseException e) {
                // empty catch block
            }
            if (checked != null && !MagicNumberCheck.isExcluded(checked)) {
                this.context.addIssue((Tree)tree, (JavaCheck)this, "Assign this magic number " + tree.value() + " to a well-named constant, and use the constant instead.");
            }
        }
    }

    private static boolean isNumberLiteral(LiteralTree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.DOUBLE_LITERAL, Tree.Kind.FLOAT_LITERAL, Tree.Kind.LONG_LITERAL, Tree.Kind.INT_LITERAL});
    }

    private static boolean isExcluded(BigDecimal bigDecimal) {
        return bigDecimal.compareTo(BigDecimal.ONE) == 0 || bigDecimal.compareTo(BigDecimal.ZERO) == 0 || bigDecimal.compareTo(BigDecimal.ONE.negate()) == 0;
    }

    public void visitAnnotation(AnnotationTree annotationTree) {
    }

    public void visitVariable(VariableTree tree) {
        ModifiersTree modifiers = tree.modifiers();
        if (!ModifiersUtils.hasModifier((ModifiersTree)modifiers, (Modifier)Modifier.STATIC) || !ModifiersUtils.hasModifier((ModifiersTree)modifiers, (Modifier)Modifier.FINAL)) {
            super.visitVariable(tree);
        }
    }
}

