/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1221", name="Methods should not be named \"hashcode\" or \"equal\"", tags={"bug", "pitfall"}, priority=Priority.CRITICAL)
@ActivatedByDefault
@SqaleSubCharacteristic(value="ARCHITECTURE_RELIABILITY")
@SqaleConstantRemediation(value="10min")
public class MethodNamedHashcodeOrEqualCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        IdentifierTree methodIdentifier = ((MethodTree)tree).simpleName();
        String methodName = methodIdentifier.name();
        if ("hashcode".equals(methodName) || "equal".equals(methodName)) {
            String substitute = "hashCode()";
            if ("equal".equals(methodName)) {
                substitute = "equals(Object obj)";
            }
            this.addIssue((Tree)methodIdentifier, "Either override Object." + substitute + ", or totally rename the method to prevent any confusion.");
        }
    }
}

