/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2786", name="Nested \"enum\"s should not be declared static", tags={"clumsy"}, priority=Priority.MAJOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="2min")
public class NestedEnumStaticCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.ENUM);
    }

    public void visitNode(Tree tree) {
        if (NestedEnumStaticCheck.isStatic((ClassTree)tree)) {
            this.addIssue(tree, "Remove this redundant \"static\" qualifier.");
        }
    }

    private static boolean isStatic(ClassTree classTree) {
        return ModifiersUtils.hasModifier((ModifiersTree)classTree.modifiers(), (Modifier)Modifier.STATIC);
    }
}

