/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.resolve.JavaType;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ConditionalExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2154", name="Dissimilar primitive wrappers should not be used with the ternary operator without explicit casting", tags={"bug"}, priority=Priority.CRITICAL)
@ActivatedByDefault
@SqaleSubCharacteristic(value="INSTRUCTION_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class PrimitiveWrappersInTernaryOperatorCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CONDITIONAL_EXPRESSION);
    }

    public void visitNode(Tree tree) {
        Type falseExpressionType;
        ConditionalExpressionTree cet = (ConditionalExpressionTree)tree;
        Type trueExpressionType = cet.trueExpression().symbolType();
        if (PrimitiveWrappersInTernaryOperatorCheck.dissimilarPrimitiveTypeWrappers(trueExpressionType, falseExpressionType = cet.falseExpression().symbolType())) {
            this.addIssue(tree, "Add an explicit cast to match types of operands.");
        }
    }

    private static boolean dissimilarPrimitiveTypeWrappers(Type trueExprType, Type falseExprType) {
        return PrimitiveWrappersInTernaryOperatorCheck.isPrimitiveWrapper(trueExprType) && PrimitiveWrappersInTernaryOperatorCheck.isPrimitiveWrapper(falseExprType) && !trueExprType.equals(falseExprType);
    }

    private static boolean isPrimitiveWrapper(Type type) {
        return ((JavaType)type).isPrimitiveWrapper();
    }
}

