/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="StringEqualityComparisonCheck", name="Strings should be compared using \"equals()\"", tags={"cwe"}, priority=Priority.CRITICAL)
@SqaleSubCharacteristic(value="INSTRUCTION_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class StringEqualityComparisonCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.EQUAL_TO, (Object)Tree.Kind.NOT_EQUAL_TO);
    }

    public void visitNode(Tree tree) {
        BinaryExpressionTree bet = (BinaryExpressionTree)tree;
        if (bet.leftOperand().is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL}) || bet.rightOperand().is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            this.addIssue(tree, "Replace \"==\" and \"!=\" by \"equals()\" and \"!equals()\" respectively to compare these strings.");
        }
    }
}

