/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2134", name="Classes extending java.lang.Thread should override the \"run\" method", tags={"multi-threading", "pitfall"}, priority=Priority.MAJOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="5min")
public class ThreadOverridesRunCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        Symbol.TypeSymbol classSymbol = classTree.symbol();
        if (classSymbol != null && ThreadOverridesRunCheck.isDirectSubtypeOfThread(classSymbol) && !ThreadOverridesRunCheck.overridesRunMethod(classSymbol)) {
            this.addIssue(tree, "Stop extending the Thread class as the \"run\" method is not overridden");
        }
    }

    private static boolean isDirectSubtypeOfThread(Symbol.TypeSymbol classSymbol) {
        Type superClass = classSymbol.superClass();
        return superClass != null && superClass.is("java.lang.Thread");
    }

    private static boolean overridesRunMethod(Symbol.TypeSymbol classSymbol) {
        Collection runSymbols = classSymbol.lookupSymbols("run");
        boolean overridesRunMethod = false;
        for (Symbol run : runSymbols) {
            Symbol.MethodSymbol methodSymbol;
            if (!run.isMethodSymbol() || !(methodSymbol = (Symbol.MethodSymbol)run).parameterTypes().isEmpty()) continue;
            overridesRunMethod = true;
            break;
        }
        return overridesRunMethod;
    }
}

