/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ForEachStatement;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TryStatementTree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1481", name="Unused local variables should be removed", tags={"unused"}, priority=Priority.MAJOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="5min")
public class UnusedLocalVariableCheck
extends SubscriptionBaseVisitor {
    private static final Tree.Kind[] ASSIGNMENT_KINDS = new Tree.Kind[]{Tree.Kind.ASSIGNMENT, Tree.Kind.MULTIPLY_ASSIGNMENT, Tree.Kind.DIVIDE_ASSIGNMENT, Tree.Kind.REMAINDER_ASSIGNMENT, Tree.Kind.PLUS_ASSIGNMENT, Tree.Kind.MINUS_ASSIGNMENT, Tree.Kind.LEFT_SHIFT_ASSIGNMENT, Tree.Kind.RIGHT_SHIFT_ASSIGNMENT, Tree.Kind.UNSIGNED_RIGHT_SHIFT_ASSIGNMENT, Tree.Kind.AND_ASSIGNMENT, Tree.Kind.XOR_ASSIGNMENT, Tree.Kind.OR_ASSIGNMENT};
    private static final Tree.Kind[] INCREMENT_KINDS = new Tree.Kind[]{Tree.Kind.POSTFIX_DECREMENT, Tree.Kind.POSTFIX_INCREMENT, Tree.Kind.PREFIX_DECREMENT, Tree.Kind.PREFIX_INCREMENT};
    private List<VariableTree> variables = Lists.newArrayList();
    private ListMultimap<Symbol, IdentifierTree> assignments = ArrayListMultimap.create();

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.BLOCK, (Object)Tree.Kind.STATIC_INITIALIZER, (Object)Tree.Kind.FOR_STATEMENT, (Object)Tree.Kind.FOR_EACH_STATEMENT, (Object)Tree.Kind.TRY_STATEMENT, (Object)Tree.Kind.EXPRESSION_STATEMENT, (Object)Tree.Kind.COMPILATION_UNIT);
    }

    public void leaveNode(Tree tree) {
        if (this.hasSemantic()) {
            if (tree.is(new Tree.Kind[]{Tree.Kind.BLOCK, Tree.Kind.STATIC_INITIALIZER})) {
                BlockTree blockTree = (BlockTree)tree;
                this.addVariables(blockTree.body());
            } else if (tree.is(new Tree.Kind[]{Tree.Kind.FOR_STATEMENT})) {
                ForStatementTree forStatementTree = (ForStatementTree)tree;
                this.addVariables((List<StatementTree>)forStatementTree.initializer());
            } else if (tree.is(new Tree.Kind[]{Tree.Kind.FOR_EACH_STATEMENT})) {
                ForEachStatement forEachStatement = (ForEachStatement)tree;
                this.addVariable(forEachStatement.variable());
            } else if (tree.is(new Tree.Kind[]{Tree.Kind.TRY_STATEMENT})) {
                TryStatementTree tryStatementTree = (TryStatementTree)tree;
                for (VariableTree resource : tryStatementTree.resources()) {
                    this.addVariable(resource);
                }
            } else if (tree.is(new Tree.Kind[]{Tree.Kind.EXPRESSION_STATEMENT})) {
                this.leaveExpressionStatement((ExpressionStatementTree)tree);
            } else if (tree.is(new Tree.Kind[]{Tree.Kind.COMPILATION_UNIT})) {
                this.checkVariableUsages();
                this.variables.clear();
                this.assignments.clear();
            }
        }
    }

    private void leaveExpressionStatement(ExpressionStatementTree expressionStatement) {
        ExpressionTree expression = expressionStatement.expression();
        if (expression.is(ASSIGNMENT_KINDS)) {
            this.addAssignment(((AssignmentExpressionTree)expression).variable());
        } else if (expression.is(INCREMENT_KINDS)) {
            this.addAssignment(((UnaryExpressionTree)expression).expression());
        }
    }

    private void checkVariableUsages() {
        for (VariableTree variableTree : this.variables) {
            Symbol symbol = variableTree.symbol();
            if (symbol.usages().size() != this.assignments.get((Object)symbol).size()) continue;
            this.addIssue((Tree)variableTree, "Remove this unused \"" + variableTree.simpleName() + "\" local variable.");
        }
    }

    public void addVariables(List<StatementTree> statementTrees) {
        for (StatementTree statementTree : statementTrees) {
            if (!statementTree.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) continue;
            this.addVariable((VariableTree)statementTree);
        }
    }

    private void addVariable(VariableTree variableTree) {
        this.variables.add(variableTree);
    }

    private void addAssignment(ExpressionTree variable) {
        if (variable.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            this.addAssignment((IdentifierTree)variable);
        }
    }

    private void addAssignment(IdentifierTree identifier) {
        Symbol reference = identifier.symbol();
        if (!reference.isUnknown()) {
            this.assignments.put((Object)reference, (Object)identifier);
        }
    }
}

