/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.bytecode.asm.AsmClass;
import org.sonar.java.bytecode.asm.AsmMethod;
import org.sonar.java.bytecode.visitor.BytecodeVisitor;
import org.sonar.java.checks.SerializableContract;
import org.sonar.java.signature.JvmJavaType;
import org.sonar.java.signature.MethodSignatureScanner;
import org.sonar.java.signature.Parameter;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CheckMessage;
import org.sonar.squidbridge.api.SourceFile;

@Rule(key="UnusedPrivateMethod", name="Unused private method should be removed", tags={"unused"}, priority=Priority.MAJOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="5min")
public class UnusedPrivateMethodCheck
extends BytecodeVisitor {
    private AsmClass asmClass;

    public void visitClass(AsmClass asmClass) {
        this.asmClass = asmClass;
    }

    public void visitMethod(AsmMethod asmMethod) {
        if (UnusedPrivateMethodCheck.isPrivateUnused(asmMethod) && !UnusedPrivateMethodCheck.isExcludedFromCheck(asmMethod)) {
            String messageStr = "Private method '" + asmMethod.getName() + "' is never used.";
            if ("<init>".equals(asmMethod.getName())) {
                messageStr = "Private constructor '" + this.asmClass.getDisplayName() + "(";
                ArrayList params = Lists.newArrayList();
                for (Parameter param : MethodSignatureScanner.scan((String)asmMethod.getGenericKey()).getArgumentTypes()) {
                    String paramName = param.getClassName();
                    if (StringUtils.isEmpty((String)paramName)) {
                        paramName = MethodSignatureScanner.getReadableType((JvmJavaType)param.getJvmJavaType());
                    }
                    params.add(paramName + (param.isArray() ? "[]" : ""));
                }
                messageStr = messageStr + Joiner.on((String)",").join((Iterable)params) + ")' is never used.";
            }
            CheckMessage message = new CheckMessage((Object)this, messageStr, new Object[0]);
            int line = this.getMethodLineNumber(asmMethod);
            if (line > 0) {
                message.setLine(line);
            }
            SourceFile file = this.getSourceFile(this.asmClass);
            file.log(message);
        }
    }

    private static boolean isPrivateUnused(AsmMethod asmMethod) {
        return !asmMethod.isUsed() && asmMethod.isPrivate();
    }

    private static boolean isExcludedFromCheck(AsmMethod asmMethod) {
        return asmMethod.isSynthetic() || asmMethod.isDefaultConstructor() || SerializableContract.methodMatch(asmMethod);
    }
}

