/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.SyntacticEquivalence;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2123", name="Values should not be uselessly incremented", tags={"bug"}, priority=Priority.CRITICAL)
@ActivatedByDefault
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class UselessIncrementCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.RETURN_STATEMENT, (Object)Tree.Kind.ASSIGNMENT);
    }

    public void visitNode(Tree tree) {
        AssignmentExpressionTree aet;
        if (tree.is(new Tree.Kind[]{Tree.Kind.RETURN_STATEMENT})) {
            ExpressionTree returnExpression = ((ReturnStatementTree)tree).expression();
            if (returnExpression != null && UselessIncrementCheck.isPostfix(returnExpression)) {
                this.addIssue(returnExpression);
            }
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT}) && UselessIncrementCheck.isPostfix((aet = (AssignmentExpressionTree)tree).expression())) {
            UnaryExpressionTree postfix = (UnaryExpressionTree)aet.expression();
            if (SyntacticEquivalence.areEquivalent((Tree)aet.variable(), (Tree)postfix.expression())) {
                this.addIssue((ExpressionTree)postfix);
            }
        }
    }

    private void addIssue(ExpressionTree expression) {
        this.addIssue((Tree)expression, "Remove this increment or correct the code not to waste it.");
    }

    private static boolean isPostfix(ExpressionTree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.POSTFIX_INCREMENT, Tree.Kind.POSTFIX_DECREMENT});
    }
}

