/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1118", name="Utility classes should not have public constructors", tags={"design"}, priority=Priority.MAJOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="30min")
public class UtilityClassWithPublicConstructorCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        if (!UtilityClassWithPublicConstructorCheck.extendsAnotherClass(classTree) && UtilityClassWithPublicConstructorCheck.hasOnlyStaticMembers(classTree)) {
            boolean hasImplicitPublicConstructor = true;
            for (Tree explicitConstructor : UtilityClassWithPublicConstructorCheck.getExplicitConstructors(classTree)) {
                hasImplicitPublicConstructor = false;
                if (!UtilityClassWithPublicConstructorCheck.isPublicConstructor(explicitConstructor)) continue;
                this.addIssue(explicitConstructor, "Hide this public constructor.");
            }
            if (hasImplicitPublicConstructor) {
                this.addIssue((Tree)classTree, "Add a private constructor to hide the implicit public one.");
            }
        }
    }

    private static boolean extendsAnotherClass(ClassTree classTree) {
        return classTree.superClass() != null;
    }

    private static boolean hasOnlyStaticMembers(ClassTree classTree) {
        if (classTree.members().isEmpty()) {
            return false;
        }
        for (Tree member : classTree.members()) {
            if (UtilityClassWithPublicConstructorCheck.isConstructor(member) || UtilityClassWithPublicConstructorCheck.isStatic(member) || member.is(new Tree.Kind[]{Tree.Kind.EMPTY_STATEMENT})) continue;
            return false;
        }
        return true;
    }

    private static boolean isStatic(Tree member) {
        if (member.is(new Tree.Kind[]{Tree.Kind.STATIC_INITIALIZER})) {
            return true;
        }
        if (member.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
            VariableTree variableTree = (VariableTree)member;
            return UtilityClassWithPublicConstructorCheck.hasStaticModifier(variableTree.modifiers());
        }
        if (member.is(new Tree.Kind[]{Tree.Kind.METHOD})) {
            MethodTree methodTree = (MethodTree)member;
            return UtilityClassWithPublicConstructorCheck.hasStaticModifier(methodTree.modifiers());
        }
        if (UtilityClassWithPublicConstructorCheck.isClassTree(member)) {
            ClassTree classTree = (ClassTree)member;
            return UtilityClassWithPublicConstructorCheck.hasStaticModifier(classTree.modifiers());
        }
        return false;
    }

    private static boolean isClassTree(Tree member) {
        return member.is(new Tree.Kind[]{Tree.Kind.CLASS}) || member.is(new Tree.Kind[]{Tree.Kind.ANNOTATION_TYPE}) || member.is(new Tree.Kind[]{Tree.Kind.INTERFACE}) || member.is(new Tree.Kind[]{Tree.Kind.ENUM});
    }

    private static boolean hasStaticModifier(ModifiersTree modifiers) {
        return ModifiersUtils.hasModifier((ModifiersTree)modifiers, (Modifier)Modifier.STATIC);
    }

    private static List<Tree> getExplicitConstructors(ClassTree classTree) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Tree member : classTree.members()) {
            if (!UtilityClassWithPublicConstructorCheck.isConstructor(member)) continue;
            builder.add((Object)member);
        }
        return builder.build();
    }

    private static boolean isConstructor(Tree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.CONSTRUCTOR});
    }

    private static boolean isPublicConstructor(Tree tree) {
        return UtilityClassWithPublicConstructorCheck.isConstructor(tree) && UtilityClassWithPublicConstructorCheck.hasPublicModifier((MethodTree)tree);
    }

    private static boolean hasPublicModifier(MethodTree methodTree) {
        return ModifiersUtils.hasModifier((ModifiersTree)methodTree.modifiers(), (Modifier)Modifier.PUBLIC);
    }
}

