/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.locks;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.java.checks.methods.MethodInvocationMatcherCollection;
import org.sonar.java.checks.methods.MethodMatcher;
import org.sonar.java.checks.methods.TypeCriteria;
import org.sonar.java.locks.LockState;
import org.sonar.java.symexecengine.ExecutionState;
import org.sonar.java.symexecengine.State;
import org.sonar.java.symexecengine.SymbolicExecutionCheck;
import org.sonar.java.symexecengine.SymbolicValue;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

public class LockedVisitor
extends SymbolicExecutionCheck {
    private static final String JAVA_LOCK = "java.util.concurrent.locks.Lock";
    private static final MethodInvocationMatcherCollection LOCK_INVOCATIONS = LockedVisitor.lockMethodInvocationMatcher();
    private static final MethodMatcher UNLOCK_INVOCATION = MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf("java.util.concurrent.locks.Lock")).name("unlock");
    private final Set<Tree> issueTree = new HashSet<Tree>();

    private static MethodInvocationMatcherCollection lockMethodInvocationMatcher() {
        return MethodInvocationMatcherCollection.create(MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf(JAVA_LOCK)).name("lock"), MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf(JAVA_LOCK)).name("lockInterruptibly"), MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf(JAVA_LOCK)).name("tryLock").withNoParameterConstraint());
    }

    @Override
    public void initialize(ExecutionState executionState, MethodTree analyzedMethod, List<SymbolicValue> arguments) {
        for (Symbol field : LockedVisitor.getAccessibleLockFields(analyzedMethod.symbol())) {
            executionState.defineSymbol(field);
            executionState.createValueForSymbol(field, field.declaration());
        }
    }

    private static List<Symbol> getAccessibleLockFields(Symbol.MethodSymbol symbol) {
        ArrayList symbols = Lists.newArrayList();
        Symbol owner = symbol.owner();
        while (owner.isTypeSymbol()) {
            Symbol.TypeSymbol typeSymbol = (Symbol.TypeSymbol)owner;
            for (Symbol member : typeSymbol.memberSymbols()) {
                if (!member.isVariableSymbol() || !member.type().isSubtypeOf(JAVA_LOCK)) continue;
                symbols.add(member);
            }
            owner = owner.owner();
        }
        return symbols;
    }

    @Override
    protected void onExecutableElementInvocation(ExecutionState executionState, Tree tree, List<ExpressionTree> arguments) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            MethodInvocationTree methodInvocation = (MethodInvocationTree)tree;
            ExpressionTree methodSelect = methodInvocation.methodSelect();
            if (methodSelect.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                ExpressionTree expression = ((MemberSelectExpressionTree)methodSelect).expression();
                if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                    Symbol symbol = ((IdentifierTree)expression).symbol();
                    if (LOCK_INVOCATIONS.anyMatch(methodInvocation)) {
                        executionState.markValueAs(symbol, (State)new LockState.Locked((Tree)methodInvocation));
                    } else if (UNLOCK_INVOCATION.matches(methodInvocation)) {
                        executionState.markValueAs(symbol, (State)new LockState.Unlocked((Tree)methodInvocation));
                    }
                }
            }
        }
    }

    @Override
    protected void onValueUnreachable(ExecutionState executionState, State state) {
        if (state instanceof LockState.Locked) {
            this.issueTree.addAll(state.reportingTrees());
        }
    }

    public Set<Tree> getIssueTrees() {
        return this.issueTree;
    }
}

