/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.symexec;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.apache.log4j.Logger;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.LiteralUtils;
import org.sonar.java.symexec.AssignedSymbolExtractor;
import org.sonar.java.symexec.ExecutionState;
import org.sonar.java.symexec.SymbolicBooleanConstraint;
import org.sonar.java.symexec.SymbolicExecutionException;
import org.sonar.java.symexec.SymbolicRelation;
import org.sonar.java.symexec.SymbolicValue;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ArrayAccessExpressionTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.BreakStatementTree;
import org.sonar.plugins.java.api.tree.CaseGroupTree;
import org.sonar.plugins.java.api.tree.CaseLabelTree;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.ConditionalExpressionTree;
import org.sonar.plugins.java.api.tree.ContinueStatementTree;
import org.sonar.plugins.java.api.tree.DoWhileStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ForEachStatement;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.InstanceOfTree;
import org.sonar.plugins.java.api.tree.LabeledStatementTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.SwitchStatementTree;
import org.sonar.plugins.java.api.tree.SynchronizedStatementTree;
import org.sonar.plugins.java.api.tree.ThrowStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TryStatementTree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.plugins.java.api.tree.WhileStatementTree;

public class SymbolicEvaluator {
    private static final Logger LOGGER = Logger.getLogger(SymbolicEvaluator.class);
    private static final int MAXIMAL_EXECUTION_STATE_COUNT = 65536;
    private final AssignedSymbolExtractor extractor = new AssignedSymbolExtractor();
    private final Map<Tree, SymbolicBooleanConstraint> result = new HashMap<Tree, SymbolicBooleanConstraint>();
    private int currentExecutionStateCount;

    public Map<Tree, SymbolicBooleanConstraint> evaluateMethod(JavaFileScannerContext context, ExecutionState state, MethodTree tree) {
        this.result.clear();
        if (tree.block() != null) {
            try {
                this.evaluateStatement((List<ExecutionState>)ImmutableList.of((Object)state), (StatementTree)tree.block());
            }
            catch (SymbolicExecutionException e) {
                JavaTree javaTree = (JavaTree)tree;
                LOGGER.info((Object)("in " + context.getFile() + ": analysis of " + tree.simpleName().name() + " at line " + javaTree.getLine() + " failed: " + e.getMessage()));
                LOGGER.debug((Object)e);
                this.result.clear();
            }
        }
        return this.result;
    }

    PackedStates evaluateCondition(ExecutionState state, ExpressionTree tree) {
        return new ConditionVisitor().evaluate(state, tree).splitUnknowns(this);
    }

    SymbolicBooleanConstraint evaluateExpression(ExecutionState state, ExpressionTree tree) {
        return new ExpressionVisitor().evaluate(state, tree);
    }

    PackedStatementStates evaluateStatement(ExecutionState state, StatementTree tree) {
        return new StatementVisitor().evaluate(PackedStatementStates.instantiateWithState(state), (Tree)tree);
    }

    PackedStatementStates evaluateStatement(List<ExecutionState> states, StatementTree tree) {
        return new StatementVisitor().evaluate(PackedStatementStates.instantiateWithStates(states), (Tree)tree);
    }

    PackedStatementStates evaluateStatement(PackedStatementStates states, Tree tree) {
        return new StatementVisitor().evaluate(states, tree);
    }

    ExecutionState instantiateExecutionState(ExecutionState parentState) {
        if (this.currentExecutionStateCount >= 65536) {
            throw new SymbolicExecutionException("maximal number of execution states reached");
        }
        ++this.currentExecutionStateCount;
        return new ExecutionState(parentState);
    }

    static class PackedStatementStates
    implements Iterable<ExecutionState> {
        final List<ExecutionState> breakStates = new ArrayList<ExecutionState>();
        final List<ExecutionState> states = new ArrayList<ExecutionState>();

        PackedStatementStates() {
        }

        static PackedStatementStates instantiate() {
            return new PackedStatementStates();
        }

        static PackedStatementStates instantiateWithState(ExecutionState state) {
            return PackedStatementStates.instantiateWithStates((List<ExecutionState>)ImmutableList.of((Object)state));
        }

        static PackedStatementStates instantiateWithStates(List<ExecutionState> states) {
            PackedStatementStates result = new PackedStatementStates();
            result.states.addAll(states);
            return result;
        }

        static PackedStatementStates instantiateWithBreakStates(List<ExecutionState> breakStates) {
            PackedStatementStates result = new PackedStatementStates();
            result.breakStates.addAll(breakStates);
            return result;
        }

        public void addState(ExecutionState state) {
            this.states.add(state);
        }

        @Override
        public Iterator<ExecutionState> iterator() {
            return this.states.iterator();
        }

        public boolean isEmpty() {
            return this.states.isEmpty();
        }
    }

    public static class PackedStates {
        final List<ExecutionState> falseStates = new ArrayList<ExecutionState>();
        final List<ExecutionState> trueStates = new ArrayList<ExecutionState>();
        final List<ExecutionState> unknownStates = new ArrayList<ExecutionState>();

        public void add(PackedStates that) {
            this.falseStates.addAll(that.falseStates);
            this.trueStates.addAll(that.trueStates);
            this.unknownStates.addAll(that.unknownStates);
        }

        PackedStates splitUnknowns(SymbolicEvaluator evaluator) {
            for (ExecutionState state : this.unknownStates) {
                this.falseStates.add(evaluator.instantiateExecutionState(state));
                this.trueStates.add(evaluator.instantiateExecutionState(state));
            }
            this.unknownStates.clear();
            return this;
        }

        public boolean isAlwaysFalse() {
            return !this.falseStates.isEmpty() && this.trueStates.isEmpty() && this.unknownStates.isEmpty();
        }

        public boolean isAlwaysTrue() {
            return !this.trueStates.isEmpty() && this.falseStates.isEmpty() && this.unknownStates.isEmpty();
        }

        public boolean isUnknown() {
            return !this.unknownStates.isEmpty() || !this.trueStates.isEmpty() && !this.falseStates.isEmpty();
        }

        public SymbolicBooleanConstraint getBooleanConstraint() {
            if (this.isAlwaysFalse()) {
                return SymbolicBooleanConstraint.FALSE;
            }
            if (this.isAlwaysTrue()) {
                return SymbolicBooleanConstraint.TRUE;
            }
            return SymbolicBooleanConstraint.UNKNOWN;
        }
    }

    public class StatementVisitor
    extends BaseTreeVisitor {
        private PackedStatementStates currentStates;

        private PackedStatementStates evaluate(PackedStatementStates states, Tree tree) {
            this.currentStates = states;
            this.scan(tree);
            return this.currentStates;
        }

        public void visitBlock(BlockTree tree) {
            for (StatementTree statement : tree.body()) {
                this.currentStates = SymbolicEvaluator.this.evaluateStatement(this.currentStates, (Tree)statement);
            }
        }

        public void visitBreakStatement(BreakStatementTree tree) {
            this.currentStates = PackedStatementStates.instantiateWithBreakStates(this.currentStates.states);
        }

        public void visitContinueStatement(ContinueStatementTree tree) {
            this.currentStates = PackedStatementStates.instantiate();
        }

        public void visitDoWhileStatement(DoWhileStatementTree tree) {
            Set<Symbol.VariableSymbol> assignedSymbols = SymbolicEvaluator.this.extractor.findAssignedVariables((Tree)tree);
            this.invalidateAssignedVariables(assignedSymbols);
            this.currentStates = SymbolicEvaluator.this.evaluateStatement(this.currentStates, (Tree)tree.statement());
            PackedStatementStates nextStates = PackedStatementStates.instantiate();
            for (ExecutionState state : this.currentStates) {
                if (SymbolicEvaluator.this.evaluateExpression(state, tree.condition()) == SymbolicBooleanConstraint.TRUE) continue;
                nextStates.addState(state);
            }
            this.currentStates = nextStates;
            this.invalidateAssignedVariables(assignedSymbols);
        }

        public void visitExpressionStatement(ExpressionStatementTree tree) {
            for (ExecutionState state : this.currentStates) {
                SymbolicEvaluator.this.evaluateExpression(state, tree.expression());
            }
        }

        public void visitForStatement(ForStatementTree tree) {
            Set<Symbol.VariableSymbol> assignedSymbols = SymbolicEvaluator.this.extractor.findAssignedVariables((Tree)tree);
            this.invalidateAssignedVariables(assignedSymbols);
            if (tree.condition() != null) {
                PackedStatementStates nextStates = PackedStatementStates.instantiate();
                for (ExecutionState state : this.currentStates) {
                    PackedStates conditionStates = SymbolicEvaluator.this.evaluateCondition(state, tree.condition());
                    PackedStatementStates loopStates = SymbolicEvaluator.this.evaluateStatement(conditionStates.trueStates, tree.statement());
                    if (conditionStates.falseStates.isEmpty() && loopStates.isEmpty()) continue;
                    state.mergeRelations(Iterables.concat(conditionStates.falseStates, (Iterable)loopStates));
                    nextStates.addState(state);
                }
                this.currentStates = nextStates;
                this.invalidateAssignedVariables(assignedSymbols);
            } else {
                SymbolicEvaluator.this.evaluateStatement(this.currentStates, (Tree)tree.statement());
                this.currentStates = PackedStatementStates.instantiate();
            }
        }

        public void visitForEachStatement(ForEachStatement tree) {
            for (ExecutionState state : this.currentStates) {
                SymbolicEvaluator.this.evaluateExpression(state, tree.expression());
            }
            this.invalidateAssignedVariables(SymbolicEvaluator.this.extractor.findAssignedVariables((Tree)tree));
            this.currentStates = SymbolicEvaluator.this.evaluateStatement(this.currentStates, (Tree)tree.statement());
            this.invalidateAssignedVariables(SymbolicEvaluator.this.extractor.findAssignedVariables((Tree)tree));
        }

        public void visitIfStatement(IfStatementTree tree) {
            PackedStatementStates nextStates = PackedStatementStates.instantiate();
            for (ExecutionState state : this.currentStates) {
                PackedStates conditionStates = SymbolicEvaluator.this.evaluateCondition(state, tree.condition());
                SymbolicEvaluator.this.result.put(tree, conditionStates.getBooleanConstraint().union((SymbolicBooleanConstraint)((Object)SymbolicEvaluator.this.result.get(tree))));
                PackedStatementStates trueStates = SymbolicEvaluator.this.evaluateStatement(conditionStates.trueStates, tree.thenStatement());
                PackedStatementStates falseStates = tree.elseStatement() == null ? PackedStatementStates.instantiateWithStates(conditionStates.falseStates) : SymbolicEvaluator.this.evaluateStatement(conditionStates.falseStates, tree.elseStatement());
                if (!falseStates.isEmpty() || !trueStates.isEmpty()) {
                    state.mergeRelations(Iterables.concat((Iterable)falseStates, (Iterable)trueStates));
                    nextStates.addState(state);
                }
                nextStates.breakStates.addAll(falseStates.breakStates);
                nextStates.breakStates.addAll(trueStates.breakStates);
            }
            this.currentStates = nextStates;
        }

        public void visitLabeledStatement(LabeledStatementTree tree) {
            this.scan((Tree)tree.statement());
        }

        public void visitReturnStatement(ReturnStatementTree tree) {
            if (tree.expression() != null) {
                for (ExecutionState state : this.currentStates) {
                    SymbolicEvaluator.this.evaluateExpression(state, tree.expression());
                }
            }
            this.currentStates = PackedStatementStates.instantiate();
        }

        public void visitSwitchStatement(SwitchStatementTree tree) {
            PackedStatementStates nextStates = PackedStatementStates.instantiate();
            for (ExecutionState state : this.currentStates) {
                SymbolicEvaluator.this.evaluateExpression(state, tree.expression());
                ArrayList<ExecutionState> endStates = new ArrayList<ExecutionState>();
                for (int i = 0; i < tree.cases().size(); ++i) {
                    PackedStatementStates caseStates = this.processCase(tree, i, SymbolicEvaluator.this.instantiateExecutionState(state));
                    endStates.addAll(caseStates.states);
                    endStates.addAll(caseStates.breakStates);
                }
                if (!this.switchContainsDefault(tree)) {
                    endStates.add(state);
                }
                if (endStates.isEmpty()) continue;
                state.mergeRelations(endStates);
                nextStates.addState(state);
            }
            this.currentStates = nextStates;
        }

        private boolean switchContainsDefault(SwitchStatementTree tree) {
            for (CaseGroupTree caseGroupTree : tree.cases()) {
                for (CaseLabelTree label : caseGroupTree.labels()) {
                    if (!"default".equals(label.caseOrDefaultKeyword().text())) continue;
                    return true;
                }
            }
            return false;
        }

        private PackedStatementStates processCase(SwitchStatementTree tree, int caseIndex, ExecutionState state) {
            PackedStatementStates caseStates = PackedStatementStates.instantiate();
            caseStates.addState(state);
            for (int i = caseIndex; i < tree.cases().size() && !caseStates.isEmpty(); ++i) {
                caseStates = SymbolicEvaluator.this.evaluateStatement(caseStates, (Tree)tree.cases().get(i));
            }
            return caseStates;
        }

        public void visitSynchronizedStatement(SynchronizedStatementTree tree) {
            for (ExecutionState state : this.currentStates) {
                SymbolicEvaluator.this.evaluateExpression(state, tree.expression());
            }
            this.currentStates = SymbolicEvaluator.this.evaluateStatement(this.currentStates, (Tree)tree.block());
        }

        public void visitThrowStatement(ThrowStatementTree tree) {
            for (ExecutionState state : this.currentStates) {
                SymbolicEvaluator.this.evaluateExpression(state, tree.expression());
            }
            this.currentStates = PackedStatementStates.instantiate();
        }

        public void visitTryStatement(TryStatementTree tree) {
            this.currentStates = SymbolicEvaluator.this.evaluateStatement(this.currentStates, (Tree)tree.block());
            this.invalidateAssignedVariables(SymbolicEvaluator.this.extractor.findAssignedVariables((Tree)tree));
            for (ExecutionState state : this.currentStates) {
                ArrayList<ExecutionState> catchStates = new ArrayList<ExecutionState>();
                for (CatchTree catchTree : tree.catches()) {
                    catchStates.addAll(SymbolicEvaluator.this.evaluateStatement((ExecutionState)SymbolicEvaluator.this.instantiateExecutionState((ExecutionState)state), (StatementTree)catchTree.block()).states);
                }
                catchStates.add(state);
                state.mergeRelations(catchStates);
            }
            this.currentStates = SymbolicEvaluator.this.evaluateStatement(this.currentStates, (Tree)tree.finallyBlock());
        }

        public void visitVariable(VariableTree tree) {
            if (tree.initializer() != null) {
                for (ExecutionState state : this.currentStates) {
                    state.setBooleanConstraint(new SymbolicValue.SymbolicVariableValue((Symbol.VariableSymbol)tree.symbol()), SymbolicEvaluator.this.evaluateExpression(state, tree.initializer()));
                }
            }
        }

        public void visitWhileStatement(WhileStatementTree tree) {
            Set<Symbol.VariableSymbol> assignedSymbols = SymbolicEvaluator.this.extractor.findAssignedVariables((Tree)tree);
            this.invalidateAssignedVariables(assignedSymbols);
            PackedStatementStates nextStates = PackedStatementStates.instantiate();
            for (ExecutionState state : this.currentStates) {
                PackedStates conditionStates = SymbolicEvaluator.this.evaluateCondition(state, tree.condition());
                PackedStatementStates loopStates = SymbolicEvaluator.this.evaluateStatement(conditionStates.trueStates, tree.statement());
                if (conditionStates.falseStates.isEmpty() && loopStates.isEmpty()) continue;
                state.mergeRelations(Iterables.concat(conditionStates.falseStates, (Iterable)loopStates));
                nextStates.addState(state);
            }
            this.currentStates = nextStates;
            this.invalidateAssignedVariables(assignedSymbols);
        }

        void invalidateAssignedVariables(Set<Symbol.VariableSymbol> assignedVariables) {
            for (Symbol.VariableSymbol symbol : assignedVariables) {
                for (ExecutionState state : this.currentStates) {
                    state.setBooleanConstraint(new SymbolicValue.SymbolicVariableValue(symbol), SymbolicBooleanConstraint.UNKNOWN);
                }
            }
        }
    }

    public class ExpressionVisitor
    extends BaseExpressionVisitor {
        ExecutionState currentState;
        SymbolicBooleanConstraint currentResult;

        public SymbolicBooleanConstraint evaluate(ExecutionState state, ExpressionTree tree) {
            this.currentState = state;
            this.currentResult = SymbolicBooleanConstraint.UNKNOWN;
            this.scan((Tree)tree);
            return this.currentResult;
        }

        public final void visitArrayAccessExpression(ArrayAccessExpressionTree tree) {
            super.visitArrayAccessExpression(tree);
            this.currentResult = SymbolicBooleanConstraint.UNKNOWN;
        }

        public final void visitAssignmentExpression(AssignmentExpressionTree tree) {
            super.visitAssignmentExpression(tree);
            Symbol.VariableSymbol symbol = this.extractVariableSymbol(tree.variable());
            if (symbol != null) {
                SymbolicValue.SymbolicVariableValue variable = new SymbolicValue.SymbolicVariableValue(symbol);
                this.currentState.invalidateRelationsOnValue(variable);
                this.currentState.setBooleanConstraint(variable, this.currentResult);
            }
        }

        public final void visitConditionalExpression(ConditionalExpressionTree tree) {
            PackedStates conditionStates = SymbolicEvaluator.this.evaluateCondition(this.currentState, tree.condition());
            SymbolicBooleanConstraint conditionResult = conditionStates.getBooleanConstraint();
            this.currentResult = null;
            if (conditionResult != SymbolicBooleanConstraint.FALSE) {
                for (ExecutionState state : conditionStates.trueStates) {
                    this.currentResult = SymbolicEvaluator.this.evaluateExpression(state, tree.trueExpression()).union(this.currentResult);
                }
            }
            if (conditionResult != SymbolicBooleanConstraint.TRUE) {
                for (ExecutionState state : conditionStates.falseStates) {
                    this.currentResult = SymbolicEvaluator.this.evaluateExpression(state, tree.falseExpression()).union(this.currentResult);
                }
            }
            this.currentState.mergeRelations(Iterables.concat(conditionStates.falseStates, conditionStates.trueStates));
        }

        public void visitIdentifier(IdentifierTree tree) {
            Symbol.VariableSymbol symbol = this.extractVariableSymbol((ExpressionTree)tree);
            this.currentResult = symbol != null ? this.currentState.getBooleanConstraint(new SymbolicValue.SymbolicVariableValue(symbol)) : SymbolicBooleanConstraint.UNKNOWN;
        }

        public final void visitInstanceOf(InstanceOfTree tree) {
            this.currentResult = SymbolicBooleanConstraint.UNKNOWN;
        }

        public final void visitLiteral(LiteralTree tree) {
            this.currentResult = "false".equals(tree.value()) ? SymbolicBooleanConstraint.FALSE : ("true".equals(tree.value()) ? SymbolicBooleanConstraint.TRUE : SymbolicBooleanConstraint.UNKNOWN);
        }

        public final void visitMemberSelectExpression(MemberSelectExpressionTree tree) {
            if (this.isSuperOrThisMemberSelect((ExpressionTree)tree)) {
                this.scan((Tree)tree.identifier());
            } else {
                super.visitMemberSelectExpression(tree);
                this.currentResult = SymbolicBooleanConstraint.UNKNOWN;
            }
        }

        public final void visitMethodInvocation(MethodInvocationTree tree) {
            super.visitMethodInvocation(tree);
            this.currentState.invalidateFields();
            this.currentResult = SymbolicBooleanConstraint.UNKNOWN;
        }

        public final void visitUnaryExpression(UnaryExpressionTree tree) {
            super.visitUnaryExpression(tree);
            if (tree.is(new Tree.Kind[]{Tree.Kind.LOGICAL_COMPLEMENT})) {
                this.currentResult = this.currentResult.negate();
            } else {
                Symbol.VariableSymbol symbol;
                if (tree.is(new Tree.Kind[]{Tree.Kind.POSTFIX_DECREMENT, Tree.Kind.POSTFIX_INCREMENT, Tree.Kind.PREFIX_DECREMENT, Tree.Kind.PREFIX_INCREMENT}) && (symbol = this.extractVariableSymbol(tree.expression())) != null) {
                    this.currentState.invalidateRelationsOnValue(new SymbolicValue.SymbolicVariableValue(symbol));
                }
                this.currentResult = SymbolicBooleanConstraint.UNKNOWN;
            }
        }

        @Override
        void evaluateConditionalAnd(BinaryExpressionTree tree) {
            PackedStates leftStates = SymbolicEvaluator.this.evaluateCondition(this.currentState, tree.leftOperand());
            this.currentResult = leftStates.getBooleanConstraint();
            if (this.currentResult != SymbolicBooleanConstraint.FALSE) {
                this.currentResult = null;
                for (ExecutionState state : leftStates.trueStates) {
                    this.currentResult = SymbolicEvaluator.this.evaluateExpression(state, tree.rightOperand()).union(this.currentResult);
                }
                if (this.currentResult != SymbolicBooleanConstraint.FALSE) {
                    this.currentResult = leftStates.getBooleanConstraint().union(this.currentResult);
                }
            }
            this.currentState.mergeRelations(Iterables.concat(leftStates.falseStates, leftStates.trueStates));
        }

        @Override
        void evaluateConditionalOr(BinaryExpressionTree tree) {
            PackedStates leftStates = SymbolicEvaluator.this.evaluateCondition(this.currentState, tree.leftOperand());
            this.currentResult = leftStates.getBooleanConstraint();
            if (this.currentResult != SymbolicBooleanConstraint.TRUE) {
                this.currentResult = null;
                for (ExecutionState state : leftStates.falseStates) {
                    this.currentResult = SymbolicEvaluator.this.evaluateExpression(state, tree.rightOperand()).union(this.currentResult);
                }
                if (this.currentResult != SymbolicBooleanConstraint.TRUE) {
                    this.currentResult = leftStates.getBooleanConstraint().union(this.currentResult);
                }
            }
            this.currentState.mergeRelations(Iterables.concat(leftStates.falseStates, leftStates.trueStates));
        }

        @Override
        void evaluateRelationalOperator(BinaryExpressionTree tree, SymbolicRelation operator) {
            SymbolicValue leftValue = this.retrieveSymbolicValue(tree.leftOperand());
            SymbolicValue rightValue = this.retrieveSymbolicValue(tree.rightOperand());
            this.currentResult = leftValue != null && rightValue != null ? this.currentState.evaluateRelation(leftValue, operator, rightValue) : SymbolicBooleanConstraint.UNKNOWN;
        }
    }

    public class ConditionVisitor
    extends BaseExpressionVisitor {
        ExecutionState currentState;
        PackedStates currentResult;

        public PackedStates evaluate(ExecutionState state, ExpressionTree tree) {
            this.currentState = state;
            this.currentResult = new PackedStates();
            this.scan((Tree)tree);
            return this.currentResult;
        }

        public final void visitArrayAccessExpression(ArrayAccessExpressionTree tree) {
            SymbolicEvaluator.this.evaluateExpression(this.currentState, tree.expression());
            SymbolicEvaluator.this.evaluateExpression(this.currentState, tree.dimension().expression());
            this.currentResult.unknownStates.add(this.currentState);
        }

        public final void visitAssignmentExpression(AssignmentExpressionTree tree) {
            SymbolicEvaluator.this.evaluateExpression(this.currentState, tree.variable());
            SymbolicBooleanConstraint assignedValue = SymbolicEvaluator.this.evaluateExpression(this.currentState, tree.expression());
            Symbol.VariableSymbol symbol = this.extractVariableSymbol(tree.variable());
            if (symbol != null) {
                this.currentState.setBooleanConstraint(new SymbolicValue.SymbolicVariableValue(symbol), assignedValue);
            }
            if (assignedValue == SymbolicBooleanConstraint.FALSE) {
                this.currentResult.falseStates.add(this.currentState);
            } else if (assignedValue == SymbolicBooleanConstraint.TRUE) {
                this.currentResult.trueStates.add(this.currentState);
            } else {
                this.currentResult.unknownStates.add(this.currentState);
            }
        }

        public final void visitConditionalExpression(ConditionalExpressionTree tree) {
            PackedStates conditionStates = SymbolicEvaluator.this.evaluateCondition(this.currentState, tree.condition());
            for (ExecutionState state : conditionStates.trueStates) {
                PackedStates trueResult = SymbolicEvaluator.this.evaluateCondition(state, tree.trueExpression());
                this.currentResult.add(trueResult);
            }
            for (ExecutionState state : conditionStates.falseStates) {
                PackedStates falseResult = SymbolicEvaluator.this.evaluateCondition(state, tree.falseExpression());
                this.currentResult.add(falseResult);
            }
        }

        public void visitIdentifier(IdentifierTree tree) {
            Symbol.VariableSymbol symbol = this.extractVariableSymbol((ExpressionTree)tree);
            if (symbol != null) {
                SymbolicValue.SymbolicVariableValue value = new SymbolicValue.SymbolicVariableValue(symbol);
                switch (this.currentState.getBooleanConstraint(value)) {
                    case FALSE: {
                        this.currentResult.falseStates.add(this.currentState);
                        return;
                    }
                    case TRUE: {
                        this.currentResult.trueStates.add(this.currentState);
                        return;
                    }
                }
                this.currentResult.falseStates.add(SymbolicEvaluator.this.instantiateExecutionState(this.currentState).setBooleanConstraint(value, SymbolicBooleanConstraint.FALSE));
                this.currentResult.trueStates.add(SymbolicEvaluator.this.instantiateExecutionState(this.currentState).setBooleanConstraint(value, SymbolicBooleanConstraint.TRUE));
                return;
            }
            this.currentResult.unknownStates.add(this.currentState);
        }

        public final void visitInstanceOf(InstanceOfTree tree) {
            this.currentResult.unknownStates.add(this.currentState);
        }

        public final void visitLiteral(LiteralTree tree) {
            if ("false".equals(tree.value())) {
                this.currentResult.falseStates.add(this.currentState);
            } else if ("true".equals(tree.value())) {
                this.currentResult.trueStates.add(this.currentState);
            } else {
                this.currentResult.unknownStates.add(this.currentState);
            }
        }

        public final void visitMemberSelectExpression(MemberSelectExpressionTree tree) {
            if (this.isSuperOrThisMemberSelect((ExpressionTree)tree)) {
                this.scan((Tree)tree.identifier());
            } else {
                this.currentResult.unknownStates.add(this.currentState);
            }
        }

        public final void visitMethodInvocation(MethodInvocationTree tree) {
            this.currentState.invalidateFields();
            this.currentResult.unknownStates.add(this.currentState);
        }

        public final void visitUnaryExpression(UnaryExpressionTree tree) {
            if (tree.is(new Tree.Kind[]{Tree.Kind.LOGICAL_COMPLEMENT})) {
                PackedStates unaryResult = SymbolicEvaluator.this.evaluateCondition(this.currentState, tree.expression());
                this.currentResult.falseStates.addAll(unaryResult.trueStates);
                this.currentResult.trueStates.addAll(unaryResult.falseStates);
                this.currentResult.unknownStates.addAll(unaryResult.unknownStates);
            } else {
                this.currentResult.unknownStates.add(this.currentState);
            }
        }

        @Override
        void evaluateConditionalAnd(BinaryExpressionTree tree) {
            PackedStates leftResult = SymbolicEvaluator.this.evaluateCondition(this.currentState, tree.leftOperand());
            this.currentResult.falseStates.addAll(leftResult.falseStates);
            for (ExecutionState state : leftResult.trueStates) {
                PackedStates rightResult = SymbolicEvaluator.this.evaluateCondition(state, tree.rightOperand());
                this.currentResult.add(rightResult);
            }
        }

        @Override
        void evaluateConditionalOr(BinaryExpressionTree tree) {
            PackedStates leftResult = SymbolicEvaluator.this.evaluateCondition(this.currentState, tree.leftOperand());
            this.currentResult.trueStates.addAll(leftResult.trueStates);
            for (ExecutionState state : leftResult.falseStates) {
                PackedStates rightResult = SymbolicEvaluator.this.evaluateCondition(state, tree.rightOperand());
                this.currentResult.add(rightResult);
            }
        }

        @Override
        void evaluateRelationalOperator(BinaryExpressionTree tree, SymbolicRelation operator) {
            SymbolicValue leftValue = this.retrieveSymbolicValue(tree.leftOperand());
            SymbolicValue rightValue = this.retrieveSymbolicValue(tree.rightOperand());
            if (leftValue != null && rightValue != null) {
                switch (this.currentState.evaluateRelation(leftValue, operator, rightValue)) {
                    case FALSE: {
                        this.currentResult.falseStates.add(this.currentState);
                        break;
                    }
                    case TRUE: {
                        this.currentResult.trueStates.add(this.currentState);
                        break;
                    }
                    default: {
                        this.currentResult.falseStates.add(SymbolicEvaluator.this.instantiateExecutionState(this.currentState).setRelation(leftValue, operator.negate(), rightValue));
                        this.currentResult.trueStates.add(SymbolicEvaluator.this.instantiateExecutionState(this.currentState).setRelation(leftValue, operator, rightValue));
                        break;
                    }
                }
            } else {
                this.currentResult.unknownStates.add(this.currentState);
            }
        }
    }

    static abstract class BaseExpressionVisitor
    extends BaseTreeVisitor {
        BaseExpressionVisitor() {
        }

        public final void visitBinaryExpression(BinaryExpressionTree tree) {
            if (tree.is(new Tree.Kind[]{Tree.Kind.CONDITIONAL_AND})) {
                this.evaluateConditionalAnd(tree);
            } else if (tree.is(new Tree.Kind[]{Tree.Kind.CONDITIONAL_OR})) {
                this.evaluateConditionalOr(tree);
            } else if (tree.is(new Tree.Kind[]{Tree.Kind.EQUAL_TO})) {
                this.evaluateRelationalOperator(tree, SymbolicRelation.EQUAL_TO);
            } else if (tree.is(new Tree.Kind[]{Tree.Kind.GREATER_THAN})) {
                this.evaluateRelationalOperator(tree, SymbolicRelation.GREATER_THAN);
            } else if (tree.is(new Tree.Kind[]{Tree.Kind.GREATER_THAN_OR_EQUAL_TO})) {
                this.evaluateRelationalOperator(tree, SymbolicRelation.GREATER_EQUAL);
            } else if (tree.is(new Tree.Kind[]{Tree.Kind.LESS_THAN})) {
                this.evaluateRelationalOperator(tree, SymbolicRelation.LESS_THAN);
            } else if (tree.is(new Tree.Kind[]{Tree.Kind.LESS_THAN_OR_EQUAL_TO})) {
                this.evaluateRelationalOperator(tree, SymbolicRelation.LESS_EQUAL);
            } else if (tree.is(new Tree.Kind[]{Tree.Kind.NOT_EQUAL_TO})) {
                this.evaluateRelationalOperator(tree, SymbolicRelation.NOT_EQUAL);
            }
        }

        abstract void evaluateConditionalAnd(BinaryExpressionTree var1);

        abstract void evaluateConditionalOr(BinaryExpressionTree var1);

        abstract void evaluateRelationalOperator(BinaryExpressionTree var1, SymbolicRelation var2);

        @CheckForNull
        final SymbolicValue retrieveSymbolicValue(ExpressionTree tree) {
            ExpressionTree currentTree = tree;
            if (this.isSuperOrThisMemberSelect(tree)) {
                currentTree = ((MemberSelectExpressionTree)currentTree).identifier();
            }
            if (currentTree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                IdentifierTree identifierTree = (IdentifierTree)currentTree;
                Symbol symbol = identifierTree.symbol();
                if (symbol.isVariableSymbol()) {
                    return new SymbolicValue.SymbolicVariableValue((Symbol.VariableSymbol)symbol);
                }
            } else {
                Long value = LiteralUtils.longLiteralValue((ExpressionTree)currentTree);
                if (value != null) {
                    return new SymbolicValue.SymbolicLongValue(value);
                }
            }
            return null;
        }

        @CheckForNull
        final Symbol.VariableSymbol extractVariableSymbol(ExpressionTree tree) {
            IdentifierTree identifierTree;
            Symbol symbol;
            ExpressionTree currentTree = tree;
            if (this.isSuperOrThisMemberSelect(tree)) {
                currentTree = ((MemberSelectExpressionTree)currentTree).identifier();
            }
            if (currentTree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && (symbol = (identifierTree = (IdentifierTree)currentTree).symbol()).isVariableSymbol()) {
                return (Symbol.VariableSymbol)symbol;
            }
            return null;
        }

        final boolean isSuperOrThisMemberSelect(ExpressionTree tree) {
            IdentifierTree identifierExpression;
            MemberSelectExpressionTree memberSelectTree;
            return tree.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && (memberSelectTree = (MemberSelectExpressionTree)tree).expression().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && ("super".equals((identifierExpression = (IdentifierTree)memberSelectTree.expression()).name()) || "this".equals(identifierExpression.name()));
        }
    }
}

