/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sonar.check.Rule;
import org.sonar.java.RspecKey;
import org.sonar.java.checks.JavaFootprint;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.SyntaxTrivia;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.recognizer.CodeRecognizer;
import org.sonar.squidbridge.recognizer.LanguageFootprint;

@Rule(key="CommentedOutCodeLine")
@RspecKey(value="S125")
public class CommentedOutCodeLineCheck
extends IssuableSubscriptionVisitor {
    private static final double THRESHOLD = 0.9;
    private static final String START_JSNI = "/*-{";
    private static final String END_JSNI = "}-*/";
    private final CodeRecognizer codeRecognizer = new CodeRecognizer(0.9, (LanguageFootprint)new JavaFootprint());
    private List<SyntaxTrivia> comments;

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.TRIVIA);
    }

    public void scanFile(JavaFileScannerContext context) {
        this.comments = Lists.newArrayList();
        super.scanFile(context);
        this.leaveFile();
    }

    public void visitTrivia(SyntaxTrivia syntaxTrivia) {
        if (!(CommentedOutCodeLineCheck.isHeader(syntaxTrivia) || CommentedOutCodeLineCheck.isJavadoc(syntaxTrivia.comment()) || CommentedOutCodeLineCheck.isJSNI(syntaxTrivia.comment()))) {
            this.comments.add(syntaxTrivia);
        }
    }

    private static boolean isHeader(SyntaxTrivia syntaxTrivia) {
        return syntaxTrivia.startLine() == 1;
    }

    private void leaveFile() {
        ArrayList commentedOutCodeLines = Lists.newArrayList();
        for (SyntaxTrivia syntaxTrivia : this.comments) {
            commentedOutCodeLines.addAll(this.handleCommentsForTrivia(syntaxTrivia));
        }
        Collections.sort(commentedOutCodeLines);
        int prev = Integer.MIN_VALUE;
        for (Integer commentedOutCodeLine : commentedOutCodeLines) {
            if (prev + 1 < commentedOutCodeLine) {
                this.addIssue(commentedOutCodeLine, "This block of commented-out lines of code should be removed.");
            }
            prev = commentedOutCodeLine;
        }
        this.comments = null;
    }

    private List<Integer> handleCommentsForTrivia(SyntaxTrivia syntaxTrivia) {
        ArrayList<Integer> commentedOutCodeLines = new ArrayList<Integer>();
        String[] lines = syntaxTrivia.comment().split("\r\n?|\n");
        for (int i = 0; i < lines.length; ++i) {
            if (!this.codeRecognizer.isLineOfCode(lines[i])) continue;
            for (int j = i; j < lines.length; ++j) {
                commentedOutCodeLines.add(syntaxTrivia.startLine() + j);
            }
            break;
        }
        return commentedOutCodeLines;
    }

    private static boolean isJavadoc(String comment) {
        return StringUtils.startsWith((String)comment, (String)"/**");
    }

    private static boolean isJSNI(String comment) {
        return StringUtils.startsWith((String)comment, (String)START_JSNI) && StringUtils.endsWith((String)comment, (String)END_JSNI);
    }
}

