/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ConditionalExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2789")
public class NullShouldNotBeUsedWithOptionalCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final String NULLABLE = "javax.annotation.Nullable";
    private static final String OPTIONAL = "java.util.Optional";
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitMethod(MethodTree method) {
        if (!method.is(new Tree.Kind[]{Tree.Kind.CONSTRUCTOR}) && NullShouldNotBeUsedWithOptionalCheck.returnsOptional(method)) {
            this.checkNullableAnnotation(method.modifiers(), "Methods with an \"Optional\" return type should not be \"@Nullable\".");
            method.accept((TreeVisitor)new ReturnNullVisitor());
        }
        super.visitMethod(method);
    }

    public void visitBinaryExpression(BinaryExpressionTree binaryExpression) {
        if (binaryExpression.is(new Tree.Kind[]{Tree.Kind.EQUAL_TO, Tree.Kind.NOT_EQUAL_TO})) {
            ExpressionTree left = binaryExpression.leftOperand();
            ExpressionTree right = binaryExpression.rightOperand();
            if (NullShouldNotBeUsedWithOptionalCheck.isOptional(left) && NullShouldNotBeUsedWithOptionalCheck.isNull(right) || NullShouldNotBeUsedWithOptionalCheck.isNull(left) && NullShouldNotBeUsedWithOptionalCheck.isOptional(right)) {
                this.context.reportIssue((JavaCheck)this, (Tree)binaryExpression, "Remove this null-check of an \"Optional\".");
            }
        }
        super.visitBinaryExpression(binaryExpression);
    }

    public void visitVariable(VariableTree variable) {
        if (variable.type().symbolType().is(OPTIONAL)) {
            this.checkNullableAnnotation(variable.modifiers(), "\"Optional\" variables should not be \"@Nullable\".");
        }
        super.visitVariable(variable);
    }

    private static boolean returnsOptional(MethodTree method) {
        return method.returnType().symbolType().is(OPTIONAL);
    }

    private static boolean isOptional(ExpressionTree expression) {
        return expression.symbolType().is(OPTIONAL) && !NullShouldNotBeUsedWithOptionalCheck.isNull(expression);
    }

    private static boolean isNull(ExpressionTree expression) {
        return expression.is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL});
    }

    private void checkNullableAnnotation(ModifiersTree modifiers, String message) {
        for (AnnotationTree annotation : modifiers.annotations()) {
            Type type = annotation.annotationType().symbolType();
            if (!type.is(NULLABLE)) continue;
            this.context.reportIssue((JavaCheck)this, (Tree)annotation, message);
        }
    }

    private class ReturnNullVisitor
    extends BaseTreeVisitor {
        private ReturnNullVisitor() {
        }

        public void visitReturnStatement(ReturnStatementTree returnStatement) {
            this.checkNull(returnStatement.expression());
            super.visitReturnStatement(returnStatement);
        }

        public void visitConditionalExpression(ConditionalExpressionTree conditionalExpression) {
            if (conditionalExpression.symbolType().is(NullShouldNotBeUsedWithOptionalCheck.OPTIONAL)) {
                this.checkNull(conditionalExpression.trueExpression());
                this.checkNull(conditionalExpression.falseExpression());
            }
            super.visitConditionalExpression(conditionalExpression);
        }

        private void checkNull(ExpressionTree expression) {
            if (NullShouldNotBeUsedWithOptionalCheck.isNull(expression)) {
                NullShouldNotBeUsedWithOptionalCheck.this.context.reportIssue((JavaCheck)NullShouldNotBeUsedWithOptionalCheck.this, (Tree)expression, "Methods with an \"Optional\" return type should never return null.");
            }
        }

        public void visitLambdaExpression(LambdaExpressionTree lambdaExpressionTree) {
        }

        public void visitClass(ClassTree tree) {
        }
    }
}

