/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.resolve.SemanticModel;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.ImportTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1942")
public class SimpleClassNameCheck
extends IssuableSubscriptionVisitor {
    private static final String MESSAGE = "Replace this fully qualified name with \"%s\"";
    private List<ImportTree> importTrees = new ArrayList<ImportTree>();
    private boolean fileContainsStarImport = false;

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.IMPORT);
    }

    public void scanFile(JavaFileScannerContext context) {
        super.scanFile(context);
        if (!this.fileContainsStarImport) {
            this.checkImports();
        }
        this.fileContainsStarImport = false;
        this.importTrees.clear();
    }

    public void visitNode(Tree tree) {
        IdentifierTree identifier;
        if (!this.hasSemantic()) {
            return;
        }
        ImportTree importTree = (ImportTree)tree;
        if (importTree.qualifiedIdentifier().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && "*".equals((identifier = ((MemberSelectExpressionTree)importTree.qualifiedIdentifier()).identifier()).name())) {
            this.fileContainsStarImport = true;
            return;
        }
        this.importTrees.add(importTree);
    }

    private void checkImports() {
        SemanticModel semanticModel = (SemanticModel)this.context.getSemanticModel();
        for (ImportTree importTree : this.importTrees) {
            Symbol symbol = semanticModel.getSymbol((Tree)importTree);
            if (symbol == null) continue;
            this.checkImportedSymbol(symbol);
        }
    }

    private void checkImportedSymbol(Symbol symbol) {
        for (IdentifierTree usageIdentifier : symbol.usages()) {
            Tree parent = usageIdentifier.parent();
            if (!parent.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) || !((MemberSelectExpressionTree)parent).expression().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) continue;
            this.reportIssue(parent, String.format(MESSAGE, symbol.name()));
        }
    }
}

