/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.CharsetAwareVisitor;
import org.sonar.java.RspecKey;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.EmptyStatementTree;
import org.sonar.plugins.java.api.tree.ImportClauseTree;
import org.sonar.plugins.java.api.tree.ImportTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S00103")
@RspecKey(value="S103")
public class TooLongLineCheck
extends IssuableSubscriptionVisitor
implements CharsetAwareVisitor {
    private static final int DEFAULT_MAXIMUM_LINE_LENGTH = 120;
    @RuleProperty(key="maximumLineLength", description="The maximum authorized line length.", defaultValue="120")
    int maximumLineLength = 120;
    private Charset charset;
    private Set<Integer> ignoredLines = Sets.newHashSet();

    public List<Tree.Kind> nodesToVisit() {
        return Collections.emptyList();
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.ignoredLines.clear();
        this.ignoreLines(context.getTree());
        super.scanFile(context);
        this.visitFile(context.getFile());
    }

    private void ignoreLines(CompilationUnitTree tree) {
        List imports = tree.imports();
        if (!imports.isEmpty()) {
            int start = TooLongLineCheck.getLine((ImportClauseTree)imports.get(0), true);
            int end = TooLongLineCheck.getLine((ImportClauseTree)imports.get(imports.size() - 1), false);
            for (int i = start; i <= end; ++i) {
                this.ignoredLines.add(i);
            }
        }
    }

    private static int getLine(ImportClauseTree importClauseTree, boolean fromStart) {
        if (importClauseTree.is(new Tree.Kind[]{Tree.Kind.IMPORT})) {
            if (fromStart) {
                return ((ImportTree)importClauseTree).importKeyword().line();
            }
            return ((ImportTree)importClauseTree).semicolonToken().line();
        }
        return ((EmptyStatementTree)importClauseTree).semicolonToken().line();
    }

    private void visitFile(File file) {
        List lines;
        try {
            lines = Files.readLines((File)file, (Charset)this.charset);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        for (int i = 0; i < lines.size(); ++i) {
            String origLine;
            String line;
            if (this.ignoredLines.contains(i + 1) || (line = TooLongLineCheck.removeIgnoredPatterns(origLine = (String)lines.get(i))).length() <= this.maximumLineLength) continue;
            this.addIssue(i + 1, MessageFormat.format("Split this {0} characters long line (which is greater than {1} authorized).", origLine.length(), this.maximumLineLength));
        }
    }

    private static String removeIgnoredPatterns(String line) {
        return line.replaceAll("^(\\s*(\\*|//).*?)\\s*\\{@link [^}]+\\}\\s*", "$1").replaceAll("^(\\s*(\\*|//).*?)\\s*@see .+\\s*", "$1");
    }
}

