/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1448")
public class TooManyMethodsCheck
extends IssuableSubscriptionVisitor {
    private static final int DEFAULT_MAXIMUM = 35;
    @RuleProperty(key="maximumMethodThreshold", description="The maximum number of methods authorized in a class.", defaultValue="35")
    public int maximumMethodThreshold = 35;
    @RuleProperty(key="countNonpublicMethods", description="Whether or not to include non-public methods in the count.", defaultValue="true")
    public boolean countNonPublic = true;

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS, (Object)Tree.Kind.ENUM, (Object)Tree.Kind.INTERFACE, (Object)Tree.Kind.ANNOTATION_TYPE);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        ClassTree classTree = (ClassTree)tree;
        List<Tree> methods = classTree.members().stream().filter(member -> member.is(new Tree.Kind[]{Tree.Kind.METHOD, Tree.Kind.CONSTRUCTOR}) && (this.countNonPublic || ((MethodTree)member).symbol().isPublic())).collect(Collectors.toList());
        if (this.shouldNotReportIssue(classTree, methods)) {
            return;
        }
        List secondary = methods.stream().map(element -> new JavaFileScannerContext.Location("Method + 1", element)).collect(Collectors.toList());
        String classDescription = classTree.simpleName() == null ? "Anonymous class \"" + ((NewClassTree)classTree.parent()).identifier().symbolType().name() + "\"" : classTree.declarationKeyword().text() + " \"" + classTree.simpleName() + "\"";
        this.reportIssue(ExpressionsHelper.reportOnClassTree(classTree), String.format("%s has %d%s methods, which is greater than the %d authorized. Split it into smaller classes.", classDescription, methods.size(), this.countNonPublic ? "" : " public", this.maximumMethodThreshold), secondary, null);
    }

    private boolean shouldNotReportIssue(ClassTree classTree, List<Tree> methods) {
        return classTree.simpleName() == null && methods.stream().filter(member -> !TooManyMethodsCheck.isOverriding((MethodTree)member)).count() == 0L || methods.size() <= this.maximumMethodThreshold;
    }

    private static boolean isOverriding(MethodTree member) {
        Symbol.MethodSymbol symbol = member.symbol();
        return symbol.isMethodSymbol() && ((JavaSymbol.MethodJavaSymbol)symbol).overriddenSymbol() != null;
    }
}

