/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.helpers;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.VariableTree;

public class ReassignmentFinder
extends BaseTreeVisitor {
    private final List<IdentifierTree> usages;
    private List<Tree> reassignments;

    private ReassignmentFinder(List<IdentifierTree> usages) {
        this.usages = usages;
        this.reassignments = new LinkedList<Tree>();
    }

    @CheckForNull
    public static ExpressionTree getClosestReassignmentOrDeclarationExpression(Tree startingPoint, Symbol referenceSymbol) {
        Tree result = referenceSymbol.declaration();
        List usages = referenceSymbol.usages();
        if (usages.size() != 1) {
            List<Tree> reassignments = ReassignmentFinder.getReassignments(referenceSymbol.owner().declaration(), usages);
            SyntaxToken startPointToken = startingPoint.firstToken();
            Tree lastReassignment = ReassignmentFinder.getClosestReassignment(startPointToken, reassignments);
            if (lastReassignment != null) {
                result = lastReassignment;
            }
        }
        return ReassignmentFinder.getInitializerOrExpression(result);
    }

    @CheckForNull
    private static ExpressionTree getInitializerOrExpression(@Nullable Tree tree) {
        if (tree == null) {
            return null;
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
            return ((VariableTree)tree).initializer();
        }
        return ((AssignmentExpressionTree)tree).expression();
    }

    private static List<Tree> getReassignments(@Nullable Tree ownerDeclaration, List<IdentifierTree> usages) {
        if (ownerDeclaration != null) {
            ReassignmentFinder reassignmentFinder = new ReassignmentFinder(usages);
            ownerDeclaration.accept((TreeVisitor)reassignmentFinder);
            return reassignmentFinder.reassignments;
        }
        return new ArrayList<Tree>();
    }

    @CheckForNull
    private static Tree getClosestReassignment(SyntaxToken startToken, List<Tree> reassignments) {
        Tree result = null;
        for (Tree reassignment : reassignments) {
            SyntaxToken reassignmentFirstToken = reassignment.firstToken();
            int reassignmentLine = reassignmentFirstToken.line();
            int startLine = startToken.line();
            if (startLine <= reassignmentLine && (startLine != reassignmentLine || startToken.column() <= reassignmentFirstToken.column() || ReassignmentFinder.isInAssignedExpression(startToken, reassignment))) continue;
            result = reassignment;
        }
        return result;
    }

    private static boolean isInAssignedExpression(SyntaxToken syntaxToken, Tree reassignement) {
        for (Tree parent = syntaxToken.parent(); parent != null && !parent.is(new Tree.Kind[]{Tree.Kind.EXPRESSION_STATEMENT}); parent = parent.parent()) {
            if (parent != reassignement) continue;
            return true;
        }
        return false;
    }

    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        if (this.isSearchedVariable(tree.variable())) {
            this.reassignments.add((Tree)tree);
        }
        super.visitAssignmentExpression(tree);
    }

    private boolean isSearchedVariable(ExpressionTree variable) {
        return variable.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && this.usages.contains(variable);
    }
}

