/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.serialization;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.java.resolve.ArrayJavaType;
import org.sonar.java.resolve.ParametrizedTypeJavaType;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2441")
public class SerializableObjectInSessionCheck
extends AbstractMethodDetection {
    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return ImmutableList.of((Object)MethodMatcher.create().typeDefinition("javax.servlet.http.HttpSession").name("setAttribute").addParameter("java.lang.String").addParameter(TypeCriteria.anyType()));
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        ExpressionTree argument = (ExpressionTree)mit.arguments().get(1);
        Type type = argument.symbolType();
        if (!SerializableObjectInSessionCheck.isSerializable(type)) {
            String andParameters = SerializableObjectInSessionCheck.isParametrized(type) ? " and its parameters" : "";
            this.reportIssue((Tree)argument, "Make \"" + type + "\"" + andParameters + " serializable or don't store it in the session.");
        }
    }

    private static boolean isSerializable(Type type) {
        if (type.isPrimitive()) {
            return true;
        }
        if (SerializableObjectInSessionCheck.isSerializableArray(type)) {
            return true;
        }
        if (SerializableObjectInSessionCheck.isParametrized(type)) {
            return SerializableObjectInSessionCheck.isSerializableParametrized((ParametrizedTypeJavaType)type);
        }
        return type.isSubtypeOf("java.io.Serializable");
    }

    private static boolean isSerializableArray(Type type) {
        if (type instanceof ArrayJavaType) {
            ArrayJavaType arrayJavaType = (ArrayJavaType)type;
            return SerializableObjectInSessionCheck.isSerializable((Type)arrayJavaType.elementType());
        }
        return false;
    }

    private static boolean isParametrized(Type type) {
        return type instanceof ParametrizedTypeJavaType;
    }

    private static boolean isSerializableParametrized(ParametrizedTypeJavaType type) {
        return (type.isSubtypeOf("java.io.Serializable") || type.isSubtypeOf("java.util.Collection")) && type.typeParameters().stream().allMatch(t -> SerializableObjectInSessionCheck.isSerializable((Type)type.substitution(t)));
    }
}

