/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.xml.maven;

import javax.xml.xpath.XPathExpression;
import org.apache.commons.lang.StringUtils;
import org.sonar.check.Rule;
import org.sonar.java.xml.XPathXmlCheck;
import org.sonar.java.xml.XmlCheckContext;
import org.w3c.dom.Node;

@Rule(key="S3421")
public class DeprecatedPomPropertiesCheck
extends XPathXmlCheck {
    private static final String POM_PROPERTY_PREFIX = "${pom.";
    private static final String POM_PROPERTY_SUFFIX = "}";
    private XPathExpression textsExpression;

    public void precompileXPathExpressions(XmlCheckContext context) {
        this.textsExpression = context.compile("//*[text()]");
    }

    public void scanFileWithXPathExpressions(XmlCheckContext context) {
        if ("pom.xml".equals(context.getFile().getName())) {
            for (Node textNode : context.evaluateOnDocument(this.textsExpression)) {
                String text = textNode.getFirstChild().getNodeValue();
                while (StringUtils.contains((String)text, (String)POM_PROPERTY_PREFIX)) {
                    String property = DeprecatedPomPropertiesCheck.extractPropertyName(text);
                    this.reportIssue(textNode, "Replace \"pom." + property + "\" with \"project." + property + "\".");
                    text = DeprecatedPomPropertiesCheck.skipFirstProperty(text);
                }
            }
        }
    }

    private static String skipFirstProperty(String text) {
        return text.substring(text.indexOf(POM_PROPERTY_SUFFIX, text.indexOf(POM_PROPERTY_PREFIX)));
    }

    private static String extractPropertyName(String text) {
        String property = text.substring(text.indexOf(POM_PROPERTY_PREFIX) + POM_PROPERTY_PREFIX.length());
        return property.substring(0, property.indexOf(POM_PROPERTY_SUFFIX));
    }
}

