/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.xml.maven.helpers;

import org.apache.commons.lang.StringUtils;
import org.sonar.java.checks.xml.maven.helpers.LocatedAttributeMatcher;
import org.sonar.java.checks.xml.maven.helpers.PatternMatcher;
import org.sonar.java.checks.xml.maven.helpers.RangedVersionMatcher;
import org.sonar.maven.model.maven2.Dependency;

public class MavenDependencyMatcher {
    private static final LocatedAttributeMatcher ALWAYS_MATCHING_MATCHER = LocatedAttributeMatcher.any();
    private final LocatedAttributeMatcher groupIdMatcher;
    private final LocatedAttributeMatcher artifactIdMatcher;
    private final LocatedAttributeMatcher versionMatcher;

    public MavenDependencyMatcher(String dependencyName, String version) {
        String[] name = dependencyName.split(":");
        if (name.length != 2) {
            throw new IllegalArgumentException("Invalid dependency name. Should match '[groupId]:[artifactId]' use '*' as wildcard");
        }
        this.groupIdMatcher = MavenDependencyMatcher.getMatcherForPattern(name[0].trim());
        this.artifactIdMatcher = MavenDependencyMatcher.getMatcherForPattern(name[1].trim());
        this.versionMatcher = MavenDependencyMatcher.getMatcherForVersion(version);
    }

    private static LocatedAttributeMatcher getMatcherForPattern(String pattern) {
        return StringUtils.isBlank((String)pattern) || MavenDependencyMatcher.isWildCard(pattern) ? ALWAYS_MATCHING_MATCHER : new PatternMatcher(pattern);
    }

    private static boolean isWildCard(String pattern) {
        return "*".equals(pattern);
    }

    private static LocatedAttributeMatcher getMatcherForVersion(String version) {
        if (version.contains("-")) {
            String[] bounds = version.split("-");
            return new RangedVersionMatcher(bounds[0], bounds[1]);
        }
        return MavenDependencyMatcher.getMatcherForPattern(version);
    }

    public boolean matches(Dependency dependency) {
        return this.groupIdMatcher.matches(dependency.getGroupId()) && this.artifactIdMatcher.matches(dependency.getArtifactId()) && this.versionMatcher.matches(dependency.getVersion());
    }
}

