/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.matcher;

public abstract class NameCriteria {
    public abstract boolean matches(String var1);

    public static NameCriteria any() {
        return new AnyNameCriteria();
    }

    public static NameCriteria is(String exactName) {
        return new ExactNameCriteria(exactName);
    }

    public static NameCriteria startsWith(String prefix) {
        return new PrefixNameCriteria(prefix);
    }

    private static class AnyNameCriteria
    extends NameCriteria {
        private AnyNameCriteria() {
        }

        @Override
        public boolean matches(String name) {
            return true;
        }
    }

    private static class PrefixNameCriteria
    extends NameCriteria {
        private String prefix;

        public PrefixNameCriteria(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public boolean matches(String name) {
            return name.startsWith(this.prefix);
        }
    }

    private static class ExactNameCriteria
    extends NameCriteria {
        private String exactName;

        public ExactNameCriteria(String exactName) {
            this.exactName = exactName;
        }

        @Override
        public boolean matches(String name) {
            return this.exactName.equals(name);
        }
    }
}

