/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.sonar.java.resolve.JavaType;
import org.sonar.java.resolve.Symbols;
import org.sonar.plugins.java.api.semantic.Type;

public class Types {
    public boolean isSubtype(JavaType t, JavaType s) {
        boolean result;
        if (t == s) {
            result = true;
        } else {
            switch (t.tag) {
                case 1: 
                case 2: {
                    result = t.tag == s.tag || t.tag + 2 <= s.tag && s.tag <= 7;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    result = t.tag <= s.tag && s.tag <= 7;
                    break;
                }
                case 8: 
                case 9: {
                    result = t.tag == s.tag;
                    break;
                }
                case 11: {
                    if (t.tag != s.tag) {
                        result = t.getSymbol().getSuperclass() == s;
                        break;
                    }
                    result = this.isSubtype(((JavaType.ArrayJavaType)t).elementType(), ((JavaType.ArrayJavaType)s).elementType());
                    break;
                }
                case 10: 
                case 15: 
                case 16: {
                    result = t.isSubtypeOf(s);
                    break;
                }
                case 13: {
                    result = s.tag == 13 || s.tag == 10 || s.tag == 11;
                    break;
                }
                default: {
                    result = false;
                }
            }
        }
        return result;
    }

    public Type leastUpperBound(List<Type> types) {
        Preconditions.checkArgument((types.size() > 1 ? 1 : 0) != 0);
        List<Set<Type>> supertypes = Types.supertypes(types);
        List<Type> candidates = Types.intersection(supertypes);
        List<Type> minimalCandidates = Types.minimalCandidates(candidates);
        if (minimalCandidates.isEmpty()) {
            return Symbols.unknownType;
        }
        return Types.best(minimalCandidates);
    }

    private static Type best(List<Type> minimalCandidates) {
        Type result = Symbols.unknownType;
        for (Type type : minimalCandidates) {
            if (!type.symbol().isInterface()) {
                return type;
            }
            if (!result.isUnknown()) continue;
            result = type;
        }
        return result;
    }

    private static List<Set<Type>> supertypes(Iterable<Type> types) {
        try {
            LinkedList<Set<Type>> results = new LinkedList<Set<Type>>();
            for (Type type : types) {
                Types.checkParametrizedType(type);
                LinkedHashSet<Type> supertypes = new LinkedHashSet<Type>();
                supertypes.add(type);
                for (Type type2 : ((JavaType)type).symbol.superTypes()) {
                    Types.checkParametrizedType(type2);
                    supertypes.add(type2);
                }
                results.add(supertypes);
            }
            return results;
        }
        catch (UnsupportedOperationException e) {
            return Collections.emptyList();
        }
    }

    private static void checkParametrizedType(Type type) {
        if (type instanceof JavaType.ParametrizedTypeJavaType) {
            throw new UnsupportedOperationException("Generics are not handled");
        }
    }

    private static List<Type> intersection(List<Set<Type>> supertypes) {
        if (supertypes.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<Type> results = new LinkedList<Type>((Collection)supertypes.get(0));
        for (int i = 1; i < supertypes.size(); ++i) {
            results.retainAll((Collection)supertypes.get(i));
        }
        return results;
    }

    private static List<Type> minimalCandidates(List<Type> erasedCandidates) {
        LinkedList<Type> results = new LinkedList<Type>();
        for (Type v : erasedCandidates) {
            boolean isValid = true;
            for (Type w : erasedCandidates) {
                if (w.equals(v) || !w.isSubtypeOf(v)) continue;
                isValid = false;
                break;
            }
            if (!isValid) continue;
            results.add(v);
        }
        return results;
    }
}

