/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.java.cfg.CFG;
import org.sonar.java.cfg.LiveVariables;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.model.JavaTree;
import org.sonar.java.se.CheckerDispatcher;
import org.sonar.java.se.ExplodedGraph;
import org.sonar.java.se.Pair;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.checks.ConditionAlwaysTrueOrFalseCheck;
import org.sonar.java.se.checks.LocksNotUnlockedCheck;
import org.sonar.java.se.checks.NullDereferenceCheck;
import org.sonar.java.se.checks.SECheck;
import org.sonar.java.se.checks.UnclosedResourcesCheck;
import org.sonar.java.se.constraint.ConstraintManager;
import org.sonar.java.se.constraint.ObjectConstraint;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ArrayAccessExpressionTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ConditionalExpressionTree;
import org.sonar.plugins.java.api.tree.DoWhileStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeCastTree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.plugins.java.api.tree.WhileStatementTree;

public class ExplodedGraphWalker
extends BaseTreeVisitor {
    private static final String EQUALS_METHOD_NAME = "equals";
    private static final int MAX_STEPS = 10000;
    public static final int MAX_NESTED_BOOLEAN_STATES = 10000;
    private static final Logger LOG = LoggerFactory.getLogger(ExplodedGraphWalker.class);
    private static final Set<String> THIS_SUPER = ImmutableSet.of((Object)"this", (Object)"super");
    private static final boolean DEBUG_MODE_ACTIVATED = false;
    private static final int MAX_EXEC_PROGRAM_POINT = 2;
    private static final MethodMatcher SYSTEM_EXIT_MATCHER = MethodMatcher.create().typeDefinition("java.lang.System").name("exit").addParameter("int");
    private final ConditionAlwaysTrueOrFalseCheck alwaysTrueOrFalseChecker;
    private MethodTree methodTree;
    private ExplodedGraph explodedGraph;
    private Deque<ExplodedGraph.Node> workList;
    ExplodedGraph.Node node;
    ExplodedGraph.ProgramPoint programPosition;
    ProgramState programState;
    private LiveVariables liveVariables;
    private CheckerDispatcher checkerDispatcher;
    @VisibleForTesting
    int steps;
    ConstraintManager constraintManager;
    private boolean cleanup = true;

    @VisibleForTesting
    ExplodedGraphWalker(JavaFileScannerContext context) {
        this.alwaysTrueOrFalseChecker = new ConditionAlwaysTrueOrFalseCheck();
        this.checkerDispatcher = new CheckerDispatcher(this, context, Lists.newArrayList((Object[])new SECheck[]{this.alwaysTrueOrFalseChecker, new NullDereferenceCheck(), new UnclosedResourcesCheck(), new LocksNotUnlockedCheck()}));
    }

    @VisibleForTesting
    ExplodedGraphWalker(JavaFileScannerContext context, boolean cleanup) {
        this(context);
        this.cleanup = cleanup;
    }

    private ExplodedGraphWalker(JavaFileScannerContext context, ConditionAlwaysTrueOrFalseCheck alwaysTrueOrFalseChecker, List<SECheck> seChecks) {
        this.alwaysTrueOrFalseChecker = alwaysTrueOrFalseChecker;
        this.checkerDispatcher = new CheckerDispatcher(this, context, seChecks);
    }

    @Override
    public void visitMethod(MethodTree tree) {
        super.visitMethod(tree);
        BlockTree body = tree.block();
        if (body != null) {
            this.execute(tree);
        }
    }

    private void execute(MethodTree tree) {
        this.checkerDispatcher.init();
        CFG cfg = CFG.build(tree);
        this.liveVariables = LiveVariables.analyze(cfg);
        this.explodedGraph = new ExplodedGraph();
        this.methodTree = tree;
        this.constraintManager = new ConstraintManager();
        this.workList = new LinkedList<ExplodedGraph.Node>();
        LOG.debug("Exploring Exploded Graph for method " + tree.simpleName().name() + " at line " + ((JavaTree)((Object)tree)).getLine());
        this.programState = ProgramState.EMPTY_STATE;
        this.steps = 0;
        for (ProgramState startingState : this.startingStates(tree, this.programState)) {
            this.enqueue(new ExplodedGraph.ProgramPoint(cfg.entry(), 0), startingState);
        }
        while (!this.workList.isEmpty()) {
            ++this.steps;
            if (this.steps > 10000) {
                throw new MaximumStepsReachedException("reached limit of 10000 steps for method " + tree.simpleName().name() + " in class " + tree.symbol().owner().name());
            }
            this.node = this.workList.removeFirst();
            this.programPosition = this.node.programPoint;
            this.programState = this.node.programState;
            if (this.programPosition.block.successors().isEmpty()) {
                this.checkerDispatcher.executeCheckEndOfExecutionPath(this.constraintManager);
                LOG.debug("End of potential path reached!");
                continue;
            }
            try {
                if (this.programPosition.i < this.programPosition.block.elements().size()) {
                    this.visit(this.programPosition.block.elements().get(this.programPosition.i), this.programPosition.block.terminator());
                    continue;
                }
                if (this.programPosition.block.terminator() == null) {
                    this.handleBlockExit(this.programPosition);
                    continue;
                }
                if (this.programPosition.i == this.programPosition.block.elements().size()) {
                    this.checkerDispatcher.executeCheckPostStatement(this.programPosition.block.terminator());
                    continue;
                }
                this.checkerDispatcher.executeCheckPreStatement(this.programPosition.block.terminator());
                this.handleBlockExit(this.programPosition);
            }
            catch (TooManyNestedBooleanStatesException e) {
                throw new MaximumStepsReachedException("reached maximum number of 10000 branched states for method " + tree.simpleName().name() + " in class " + tree.symbol().owner().name(), e);
            }
        }
        this.checkerDispatcher.executeCheckEndOfExecution();
        this.explodedGraph = null;
        this.workList = null;
        this.node = null;
        this.programState = null;
        this.constraintManager = null;
    }

    private Iterable<ProgramState> startingStates(MethodTree tree, ProgramState ps) {
        Iterable startingStates = Lists.newArrayList((Object[])new ProgramState[]{ps});
        boolean isEqualsMethod = EQUALS_METHOD_NAME.equals(tree.simpleName().name()) && tree.parameters().size() == 1;
        for (final VariableTree variableTree : tree.parameters()) {
            final SymbolicValue sv = this.constraintManager.createSymbolicValue(variableTree);
            startingStates = Iterables.transform((Iterable)startingStates, (Function)new Function<ProgramState, ProgramState>(){

                public ProgramState apply(ProgramState input) {
                    return input.put(variableTree.symbol(), sv);
                }
            });
            if (!isEqualsMethod && !ExplodedGraphWalker.parameterCanBeNull(variableTree)) continue;
            startingStates = Iterables.concat((Iterable)Iterables.transform((Iterable)startingStates, (Function)new Function<ProgramState, List<ProgramState>>(){

                public List<ProgramState> apply(ProgramState input) {
                    ArrayList<ProgramState> states = new ArrayList<ProgramState>();
                    states.addAll(sv.setConstraint(input, ObjectConstraint.nullConstraint(variableTree)));
                    states.addAll(sv.setConstraint(input, ObjectConstraint.NOT_NULL));
                    return states;
                }
            }));
        }
        return startingStates;
    }

    private static boolean parameterCanBeNull(VariableTree variableTree) {
        SymbolMetadata metadata = variableTree.symbol().metadata();
        return metadata.isAnnotatedWith("javax.annotation.CheckForNull") || metadata.isAnnotatedWith("javax.annotation.Nullable");
    }

    private void cleanUpProgramState(CFG.Block block) {
        if (this.cleanup) {
            this.programState = this.programState.cleanupDeadSymbols(this.liveVariables.getOut(block));
            this.programState = this.programState.cleanupConstraints();
        }
    }

    private void handleBlockExit(ExplodedGraph.ProgramPoint programPosition) {
        CFG.Block block = programPosition.block;
        Tree terminator = block.terminator();
        this.cleanUpProgramState(block);
        if (terminator != null) {
            switch (terminator.kind()) {
                case IF_STATEMENT: {
                    this.handleBranch(block, ExplodedGraphWalker.cleanupCondition(((IfStatementTree)terminator).condition()));
                    return;
                }
                case CONDITIONAL_OR: 
                case CONDITIONAL_AND: {
                    this.handleBranch(block, ((BinaryExpressionTree)terminator).leftOperand());
                    return;
                }
                case CONDITIONAL_EXPRESSION: {
                    this.handleBranch(block, ((ConditionalExpressionTree)terminator).condition());
                    return;
                }
                case FOR_STATEMENT: {
                    ExpressionTree condition = ((ForStatementTree)terminator).condition();
                    if (condition == null) break;
                    this.handleBranch(block, condition, false);
                    return;
                }
                case WHILE_STATEMENT: {
                    ExpressionTree whileCondition = ((WhileStatementTree)terminator).condition();
                    this.handleBranch(block, ExplodedGraphWalker.cleanupCondition(whileCondition), !whileCondition.is(Tree.Kind.BOOLEAN_LITERAL));
                    return;
                }
                case DO_STATEMENT: {
                    ExpressionTree doCondition = ((DoWhileStatementTree)terminator).condition();
                    this.handleBranch(block, ExplodedGraphWalker.cleanupCondition(doCondition), !doCondition.is(Tree.Kind.BOOLEAN_LITERAL));
                    return;
                }
                case SYNCHRONIZED_STATEMENT: {
                    this.resetFieldValues();
                    break;
                }
            }
        }
        if (this.node.exitPath) {
            if (block.exitBlock() != null) {
                this.enqueue(new ExplodedGraph.ProgramPoint(block.exitBlock(), 0), this.programState, true);
            } else {
                for (CFG.Block successor : block.successors()) {
                    this.enqueue(new ExplodedGraph.ProgramPoint(successor, 0), this.programState, true);
                }
            }
        } else {
            for (CFG.Block successor : block.successors()) {
                if (block.isFinallyBlock() && successor == block.exitBlock()) continue;
                this.enqueue(new ExplodedGraph.ProgramPoint(successor, 0), this.programState, successor == block.exitBlock());
            }
        }
    }

    private static Tree cleanupCondition(Tree condition) {
        if (condition.is(Tree.Kind.CONDITIONAL_AND, Tree.Kind.CONDITIONAL_OR)) {
            return ((BinaryExpressionTree)condition).rightOperand();
        }
        return condition;
    }

    private void handleBranch(CFG.Block programPosition, Tree condition) {
        this.handleBranch(programPosition, condition, true);
    }

    private void handleBranch(CFG.Block programPosition, Tree condition, boolean checkPath) {
        Pair<List<ProgramState>, List<ProgramState>> pair = this.constraintManager.assumeDual(this.programState);
        ExplodedGraph.ProgramPoint falseBlockProgramPoint = new ExplodedGraph.ProgramPoint(programPosition.falseBlock(), 0);
        for (ProgramState state : (List)pair.a) {
            ProgramState ps = state.stackValue(SymbolicValue.FALSE_LITERAL);
            this.enqueue(falseBlockProgramPoint, ps, this.node.exitPath);
            if (!checkPath) continue;
            this.alwaysTrueOrFalseChecker.evaluatedToFalse(condition);
        }
        ExplodedGraph.ProgramPoint trueBlockProgramPoint = new ExplodedGraph.ProgramPoint(programPosition.trueBlock(), 0);
        for (ProgramState state : (List)pair.b) {
            ProgramState ps = state.stackValue(SymbolicValue.TRUE_LITERAL);
            this.enqueue(trueBlockProgramPoint, ps, this.node.exitPath);
            if (!checkPath) continue;
            this.alwaysTrueOrFalseChecker.evaluatedToTrue(condition);
        }
    }

    private void visit(Tree tree, @Nullable Tree terminator) {
        LOG.debug("visiting node " + tree.kind().name() + " at line " + ((JavaTree)tree).getLine());
        if (!this.checkerDispatcher.executeCheckPreStatement(tree)) {
            return;
        }
        switch (tree.kind()) {
            case METHOD_INVOCATION: {
                MethodInvocationTree mit = (MethodInvocationTree)tree;
                if (SYSTEM_EXIT_MATCHER.matches(mit)) {
                    return;
                }
                this.executeMethodInvocation(mit);
                break;
            }
            case LABELED_STATEMENT: 
            case SWITCH_STATEMENT: 
            case EXPRESSION_STATEMENT: 
            case PARENTHESIZED_EXPRESSION: {
                throw new IllegalStateException("Cannot appear in CFG: " + tree.kind().name());
            }
            case VARIABLE: {
                this.executeVariable((VariableTree)tree, terminator);
                break;
            }
            case TYPE_CAST: {
                this.executeTypeCast((TypeCastTree)tree);
                break;
            }
            case ASSIGNMENT: 
            case MULTIPLY_ASSIGNMENT: 
            case DIVIDE_ASSIGNMENT: 
            case REMAINDER_ASSIGNMENT: 
            case PLUS_ASSIGNMENT: 
            case MINUS_ASSIGNMENT: 
            case LEFT_SHIFT_ASSIGNMENT: 
            case RIGHT_SHIFT_ASSIGNMENT: 
            case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: {
                this.executeAssignement((AssignmentExpressionTree)tree);
                break;
            }
            case AND_ASSIGNMENT: 
            case XOR_ASSIGNMENT: 
            case OR_ASSIGNMENT: {
                this.executeLogicalAssignement((AssignmentExpressionTree)tree);
                break;
            }
            case ARRAY_ACCESS_EXPRESSION: {
                this.executeArrayAccessExpression((ArrayAccessExpressionTree)tree);
                break;
            }
            case NEW_ARRAY: {
                this.executeNewArray((NewArrayTree)tree);
                break;
            }
            case NEW_CLASS: {
                this.executeNewClass((NewClassTree)tree);
                break;
            }
            case MULTIPLY: 
            case DIVIDE: 
            case REMAINDER: 
            case PLUS: 
            case MINUS: 
            case LEFT_SHIFT: 
            case RIGHT_SHIFT: 
            case UNSIGNED_RIGHT_SHIFT: 
            case AND: 
            case XOR: 
            case OR: 
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL_TO: 
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL_TO: 
            case EQUAL_TO: 
            case NOT_EQUAL_TO: {
                this.executeBinaryExpression(tree);
                break;
            }
            case POSTFIX_INCREMENT: 
            case POSTFIX_DECREMENT: 
            case PREFIX_INCREMENT: 
            case PREFIX_DECREMENT: 
            case UNARY_MINUS: 
            case UNARY_PLUS: 
            case BITWISE_COMPLEMENT: 
            case LOGICAL_COMPLEMENT: 
            case INSTANCE_OF: {
                this.executeUnaryExpression(tree);
                break;
            }
            case IDENTIFIER: {
                this.executeIdentifier((IdentifierTree)tree);
                break;
            }
            case MEMBER_SELECT: {
                this.executeMemberSelect((MemberSelectExpressionTree)tree);
                break;
            }
            case INT_LITERAL: 
            case LONG_LITERAL: 
            case FLOAT_LITERAL: 
            case DOUBLE_LITERAL: 
            case BOOLEAN_LITERAL: 
            case CHAR_LITERAL: 
            case STRING_LITERAL: 
            case NULL_LITERAL: {
                SymbolicValue val = this.constraintManager.evalLiteral((LiteralTree)tree);
                this.programState = this.programState.stackValue(val);
                break;
            }
            case LAMBDA_EXPRESSION: 
            case METHOD_REFERENCE: {
                this.programState = this.programState.stackValue(this.constraintManager.createSymbolicValue(tree));
                break;
            }
        }
        this.checkerDispatcher.executeCheckPostStatement(tree);
        this.clearStack(tree);
    }

    private void executeMethodInvocation(MethodInvocationTree mit) {
        this.setSymbolicValueOnFields(mit);
        ProgramState.Pop unstack = this.programState.unstackValue(mit.arguments().size() + 1);
        this.programState = unstack.state;
        this.logState(mit);
        this.programState = this.programState.stackValue(this.constraintManager.createMethodSymbolicValue(mit, unstack.values));
    }

    private void executeVariable(VariableTree variableTree, @Nullable Tree terminator) {
        ExpressionTree initializer = variableTree.initializer();
        if (initializer == null) {
            SymbolicValue sv = null;
            if (terminator != null && terminator.is(Tree.Kind.FOR_EACH_STATEMENT)) {
                sv = this.constraintManager.createSymbolicValue(variableTree);
            } else if (variableTree.type().symbolType().is("boolean")) {
                sv = SymbolicValue.FALSE_LITERAL;
            } else if (!variableTree.type().symbolType().isPrimitive()) {
                sv = SymbolicValue.NULL_LITERAL;
            }
            if (sv != null) {
                this.programState = this.programState.put(variableTree.symbol(), sv);
            }
        } else {
            ProgramState.Pop unstack = this.programState.unstackValue(1);
            this.programState = unstack.state;
            this.programState = this.programState.put(variableTree.symbol(), unstack.values.get(0));
        }
    }

    private void executeTypeCast(TypeCastTree typeCast) {
        Type type = typeCast.type().symbolType();
        if (type.isPrimitive()) {
            ProgramState.Pop unstack = this.programState.unstackValue(1);
            this.programState = unstack.state;
            this.programState = this.programState.stackValue(this.constraintManager.createSymbolicValue(typeCast.expression()));
        }
    }

    private void executeAssignement(AssignmentExpressionTree tree) {
        ExpressionTree variable = tree.variable();
        if (variable.is(Tree.Kind.IDENTIFIER)) {
            ProgramState.Pop unstack = this.programState.unstackValue(2);
            SymbolicValue value = tree.is(Tree.Kind.ASSIGNMENT) ? unstack.values.get(1) : this.constraintManager.createSymbolicValue(tree);
            this.programState = unstack.state;
            this.programState = this.programState.put(((IdentifierTree)variable).symbol(), value);
            this.programState = this.programState.stackValue(value);
        }
    }

    private void executeLogicalAssignement(AssignmentExpressionTree tree) {
        ExpressionTree variable = tree.variable();
        if (variable.is(Tree.Kind.IDENTIFIER)) {
            ProgramState.Pop unstack = this.programState.unstackValue(2);
            SymbolicValue assignedTo = unstack.values.get(0);
            SymbolicValue value = unstack.values.get(1);
            this.programState = unstack.state;
            SymbolicValue symbolicValue = this.constraintManager.createSymbolicValue(tree);
            symbolicValue.computedFrom((List<SymbolicValue>)ImmutableList.of((Object)assignedTo, (Object)value));
            this.programState = this.programState.put(((IdentifierTree)variable).symbol(), symbolicValue);
            this.programState = this.programState.stackValue(symbolicValue);
        }
    }

    private void executeArrayAccessExpression(ArrayAccessExpressionTree tree) {
        ProgramState.Pop unstack = this.programState.unstackValue(2);
        this.programState = unstack.state;
        this.programState = this.programState.stackValue(this.constraintManager.createSymbolicValue(tree));
    }

    private void executeNewArray(NewArrayTree newArrayTree) {
        this.programState = this.programState.unstackValue((int)newArrayTree.initializers().size()).state;
        SymbolicValue svNewArray = this.constraintManager.createSymbolicValue(newArrayTree);
        this.programState = this.programState.stackValue(svNewArray);
        this.programState = svNewArray.setSingleConstraint(this.programState, ObjectConstraint.NOT_NULL);
    }

    private void executeNewClass(NewClassTree tree) {
        NewClassTree newClassTree = tree;
        this.programState = this.programState.unstackValue((int)newClassTree.arguments().size()).state;
        SymbolicValue svNewClass = this.constraintManager.createSymbolicValue(newClassTree);
        this.programState = this.programState.stackValue(svNewClass);
        this.programState = svNewClass.setSingleConstraint(this.programState, ObjectConstraint.NOT_NULL);
    }

    private void executeBinaryExpression(Tree tree) {
        ProgramState.Pop unstackBinary = this.programState.unstackValue(2);
        this.programState = unstackBinary.state;
        SymbolicValue symbolicValue = this.constraintManager.createSymbolicValue(tree);
        symbolicValue.computedFrom(unstackBinary.values);
        this.programState = this.programState.stackValue(symbolicValue);
    }

    private void executeUnaryExpression(Tree tree) {
        ProgramState.Pop unstackUnary = this.programState.unstackValue(1);
        this.programState = unstackUnary.state;
        SymbolicValue unarySymbolicValue = this.constraintManager.createSymbolicValue(tree);
        unarySymbolicValue.computedFrom(unstackUnary.values);
        if (tree.is(Tree.Kind.POSTFIX_DECREMENT, Tree.Kind.POSTFIX_INCREMENT, Tree.Kind.PREFIX_DECREMENT, Tree.Kind.PREFIX_INCREMENT) && ((UnaryExpressionTree)tree).expression().is(Tree.Kind.IDENTIFIER)) {
            this.programState = this.programState.put(((IdentifierTree)((UnaryExpressionTree)tree).expression()).symbol(), unarySymbolicValue);
        }
        this.programState = tree.is(Tree.Kind.POSTFIX_DECREMENT, Tree.Kind.POSTFIX_INCREMENT) ? this.programState.stackValue(unstackUnary.values.get(0)) : this.programState.stackValue(unarySymbolicValue);
    }

    private void executeIdentifier(IdentifierTree tree) {
        Symbol symbol = tree.symbol();
        SymbolicValue value = this.programState.getValue(symbol);
        if (value == null) {
            value = this.constraintManager.createSymbolicValue(tree);
            this.programState = this.programState.put(symbol, value);
        }
        this.programState = this.programState.stackValue(value);
    }

    private void executeMemberSelect(MemberSelectExpressionTree mse) {
        if (!"class".equals(mse.identifier().name())) {
            ProgramState.Pop unstackMSE = this.programState.unstackValue(1);
            this.programState = unstackMSE.state;
        }
        SymbolicValue mseValue = this.constraintManager.createSymbolicValue(mse);
        this.programState = this.programState.stackValue(mseValue);
    }

    public void clearStack(Tree tree) {
        if (tree.parent().is(Tree.Kind.EXPRESSION_STATEMENT)) {
            this.programState = this.programState.clearStack();
        }
    }

    private void setSymbolicValueOnFields(MethodInvocationTree tree) {
        if (ExplodedGraphWalker.isLocalMethodInvocation(tree)) {
            this.resetFieldValues();
        }
    }

    private static boolean isLocalMethodInvocation(MethodInvocationTree tree) {
        ExpressionTree methodSelect = tree.methodSelect();
        if (methodSelect.is(Tree.Kind.IDENTIFIER)) {
            return true;
        }
        if (methodSelect.is(Tree.Kind.MEMBER_SELECT)) {
            MemberSelectExpressionTree memberSelectExpression = (MemberSelectExpressionTree)methodSelect;
            ExpressionTree target = memberSelectExpression.expression();
            if (target.is(Tree.Kind.IDENTIFIER)) {
                IdentifierTree identifier = (IdentifierTree)target;
                return THIS_SUPER.contains(identifier.name());
            }
        }
        return false;
    }

    private void resetFieldValues() {
        this.programState = this.programState.resetFieldValues(this.constraintManager);
    }

    private void logState(MethodInvocationTree mit) {
        if (mit.methodSelect().is(Tree.Kind.IDENTIFIER) && "printState".equals(((IdentifierTree)mit.methodSelect()).name())) {
            ExplodedGraphWalker.debugPrint(((JavaTree)((Object)mit)).getLine(), this.node);
        }
    }

    private static void debugPrint(Object ... toPrint) {
    }

    public void enqueue(ExplodedGraph.ProgramPoint programPoint, ProgramState programState) {
        this.enqueue(programPoint, programState, false);
    }

    public void enqueue(ExplodedGraph.ProgramPoint programPoint, ProgramState programState, boolean exitPath) {
        int nbOfExecution = programState.numberOfTimeVisited(programPoint);
        if (nbOfExecution > 2) {
            ExplodedGraphWalker.debugPrint(programState);
            return;
        }
        this.checkExplodedGraphTooBig(programState);
        ExplodedGraph.Node cachedNode = this.explodedGraph.getNode(programPoint, programState.visitedPoint(programPoint, nbOfExecution + 1));
        if (!cachedNode.isNew && exitPath == cachedNode.exitPath) {
            return;
        }
        cachedNode.exitPath = exitPath;
        this.workList.addFirst(cachedNode);
    }

    private void checkExplodedGraphTooBig(ProgramState programState) {
        if (this.steps + this.workList.size() > 5000 && programState.constraintsSize() > 75) {
            throw new ExplodedGraphTooBigException("Program state constraints are too big : stopping Symbolic Execution for method " + this.methodTree.simpleName().name() + " in class " + this.methodTree.symbol().owner().name());
        }
    }

    public static class ExplodedGraphWalkerFactory {
        private final ConditionAlwaysTrueOrFalseCheck alwaysTrueOrFalseChecker;
        private final List<SECheck> seChecks = new ArrayList<SECheck>();

        public ExplodedGraphWalkerFactory(List<JavaFileScanner> scanners) {
            ArrayList<SECheck> checks = new ArrayList<SECheck>();
            for (JavaFileScanner scanner : scanners) {
                if (!(scanner instanceof SECheck)) continue;
                checks.add((SECheck)scanner);
            }
            this.alwaysTrueOrFalseChecker = ExplodedGraphWalkerFactory.removeOrDefault(checks, new ConditionAlwaysTrueOrFalseCheck());
            this.seChecks.add(this.alwaysTrueOrFalseChecker);
            this.seChecks.add(ExplodedGraphWalkerFactory.removeOrDefault(checks, new NullDereferenceCheck()));
            this.seChecks.add(ExplodedGraphWalkerFactory.removeOrDefault(checks, new UnclosedResourcesCheck()));
            this.seChecks.add(ExplodedGraphWalkerFactory.removeOrDefault(checks, new LocksNotUnlockedCheck()));
            this.seChecks.addAll(checks);
        }

        public ExplodedGraphWalker createWalker(JavaFileScannerContext context) {
            return new ExplodedGraphWalker(context, this.alwaysTrueOrFalseChecker, this.seChecks);
        }

        private static <T extends SECheck> T removeOrDefault(List<SECheck> checks, T defaultInstance) {
            Iterator<SECheck> iterator = checks.iterator();
            while (iterator.hasNext()) {
                SECheck check = iterator.next();
                if (!check.getClass().equals(defaultInstance.getClass())) continue;
                iterator.remove();
                return (T)check;
            }
            return defaultInstance;
        }
    }

    public static class TooManyNestedBooleanStatesException
    extends RuntimeException {
    }

    public static class MaximumStepsReachedException
    extends RuntimeException {
        public MaximumStepsReachedException(String s) {
            super(s);
        }

        public MaximumStepsReachedException(String s, TooManyNestedBooleanStatesException e) {
            super(s, e);
        }
    }

    public static class ExplodedGraphTooBigException
    extends RuntimeException {
        public ExplodedGraphTooBigException(String s) {
            super(s);
        }
    }
}

