/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.xml.maven;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.List;
import javax.xml.xpath.XPath;
import org.sonar.java.AnalyzerMessage;
import org.sonar.java.SonarComponents;
import org.sonar.java.xml.XmlCheckContextImpl;
import org.sonar.java.xml.maven.PomCheck;
import org.sonar.java.xml.maven.PomCheckContext;
import org.sonar.maven.model.LocatedTree;
import org.sonar.maven.model.XmlLocation;
import org.sonar.maven.model.maven2.MavenProject;
import org.sonar.plugins.java.api.JavaCheck;
import org.w3c.dom.Document;

public class PomCheckContextImpl
extends XmlCheckContextImpl
implements PomCheckContext {
    private final MavenProject project;

    public PomCheckContextImpl(MavenProject project, Document document, File file, XPath xPath, SonarComponents sonarComponents) {
        super(document, file, xPath, sonarComponents);
        this.project = project;
    }

    @Override
    public MavenProject getMavenProject() {
        return this.project;
    }

    @Override
    public void reportIssue(PomCheck check, LocatedTree tree, String message) {
        this.getSonarComponents().addIssue(this.getFile(), check, tree.startLocation().line(), message, null);
    }

    @Override
    public void reportIssue(PomCheck check, int line, String message, List<PomCheckContext.Location> secondary) {
        File file = this.getFile();
        AnalyzerMessage analyzerMessage = new AnalyzerMessage((JavaCheck)check, file, line, message, 0);
        for (PomCheckContext.Location location : secondary) {
            AnalyzerMessage secondaryLocation = PomCheckContextImpl.getSecondaryAnalyzerMessage(check, file, location);
            analyzerMessage.secondaryLocations.add(secondaryLocation);
        }
        this.getSonarComponents().reportIssue(analyzerMessage);
    }

    @VisibleForTesting
    static AnalyzerMessage getSecondaryAnalyzerMessage(JavaCheck check, File file, PomCheckContext.Location location) {
        XmlLocation startLocation = location.tree.startLocation();
        int startLine = startLocation.line();
        int startColumn = startLocation.column();
        if (startColumn == -1) {
            startColumn = 0;
        }
        AnalyzerMessage.TextSpan ts = new AnalyzerMessage.TextSpan(startLine, startColumn, startLine, startColumn);
        return new AnalyzerMessage(check, file, ts, location.msg, 0);
    }
}

