/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitors;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.sonar.java.ast.visitors.SubscriptionVisitor;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.SyntaxTrivia;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.CommentAnalyser;

public class CommentLinesVisitor
extends SubscriptionVisitor {
    private Set<Integer> comments = Sets.newHashSet();
    private Set<Integer> noSonarLines = Sets.newHashSet();
    private boolean seenFirstToken;
    private JavaCommentAnalyser commentAnalyser = new JavaCommentAnalyser();

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)((Object)Tree.Kind.TOKEN));
    }

    public void analyzeCommentLines(CompilationUnitTree tree) {
        this.comments.clear();
        this.noSonarLines.clear();
        this.seenFirstToken = false;
        this.scanTree(tree);
    }

    @Override
    public void visitToken(SyntaxToken syntaxToken) {
        for (SyntaxTrivia trivia : syntaxToken.trivias()) {
            if (this.seenFirstToken) {
                String[] commentLines = this.commentAnalyser.getContents(trivia.comment()).split("(\r)?\n|\r", -1);
                int line = trivia.startLine();
                for (String commentLine : commentLines) {
                    if (commentLine.contains("NOSONAR")) {
                        this.noSonarLines.add(line);
                    } else if (!this.commentAnalyser.isBlank(commentLine)) {
                        this.comments.add(line);
                    }
                    ++line;
                }
                continue;
            }
            this.seenFirstToken = true;
        }
        this.seenFirstToken = true;
    }

    public Set<Integer> noSonarLines() {
        return this.noSonarLines;
    }

    public int commentLinesMetric() {
        return this.comments.size();
    }

    public static class JavaCommentAnalyser
    extends CommentAnalyser {
        public boolean isBlank(String line) {
            for (int i = 0; i < line.length(); ++i) {
                char character = line.charAt(i);
                if (Character.isWhitespace(character) || character == '*' || character == '/') continue;
                return false;
            }
            return true;
        }

        public String getContents(String comment) {
            return comment.startsWith("//") ? comment.substring(2) : comment.substring(2, comment.length() - 2);
        }
    }
}

