/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.java.resolve.JavaType;
import org.sonar.java.resolve.ParametrizedTypeCache;
import org.sonar.java.resolve.Symbols;
import org.sonar.java.resolve.TypeSubstitution;
import org.sonar.java.resolve.Types;
import org.sonar.plugins.java.api.semantic.Type;

public class TypeSubstitutionSolver {
    private final ParametrizedTypeCache parametrizedTypeCache;
    private final Symbols symbols;

    public TypeSubstitutionSolver(ParametrizedTypeCache parametrizedTypeCache, Symbols symbols) {
        this.parametrizedTypeCache = parametrizedTypeCache;
        this.symbols = symbols;
    }

    @CheckForNull
    TypeSubstitution getTypeSubstitution(JavaSymbol.MethodJavaSymbol method, JavaType site, List<JavaType> typeParams, List<JavaType> argTypes) {
        List<JavaType> formals = ((JavaType.MethodJavaType)method.type).argTypes;
        TypeSubstitution substitution = new TypeSubstitution();
        if (method.isParametrized()) {
            if (!typeParams.isEmpty()) {
                substitution = this.getSubstitutionFromTypeParams(method.typeVariableTypes, typeParams);
            } else {
                if (formals.isEmpty()) {
                    return substitution;
                }
                formals = this.applySiteSubstitutionToFormalParameters(formals, site);
                substitution = this.inferTypeSubstitution(method, formals, argTypes);
            }
            if (substitution.size() == 0 || !this.isValidSubtitution(substitution, site)) {
                return null;
            }
        }
        return substitution;
    }

    JavaType getReturnType(@Nullable JavaType returnType, JavaType defSite, JavaType callSite, boolean parametrizedMethodCall, TypeSubstitution substitution) {
        if (returnType == null) {
            return returnType;
        }
        JavaType resultType = this.applySiteSubstitution(returnType, defSite);
        if (callSite != defSite) {
            resultType = this.applySiteSubstitution(resultType, callSite);
        }
        if (TypeSubstitutionSolver.isRawTypeOfParametrizedType(callSite) && !parametrizedMethodCall) {
            return resultType.erasure();
        }
        return this.applySubstitution(resultType, substitution);
    }

    private static boolean isRawTypeOfParametrizedType(JavaType site) {
        return !TypeSubstitutionSolver.isParametrizedType(site) && !site.symbol.typeVariableTypes.isEmpty();
    }

    List<JavaType> applySiteSubstitutionToFormalParameters(List<JavaType> formals, JavaType site) {
        if (TypeSubstitutionSolver.isParametrizedType(site)) {
            return this.applySubstitutionToFormalParameters(formals, ((JavaType.ParametrizedTypeJavaType)site).typeSubstitution);
        }
        return formals;
    }

    JavaType applySiteSubstitution(JavaType type, JavaType site) {
        if (TypeSubstitutionSolver.isParametrizedType(site)) {
            return this.applySubstitution(type, ((JavaType.ParametrizedTypeJavaType)site).typeSubstitution);
        }
        return type;
    }

    JavaType applySiteSubstitution(@Nullable JavaType resolvedType, JavaType callSite, JavaType resolvedTypeDefinition) {
        if (resolvedType == null) {
            return null;
        }
        return this.applySiteSubstitution(this.applySiteSubstitution(resolvedType, resolvedTypeDefinition), callSite);
    }

    List<JavaType> applySubstitutionToFormalParameters(List<JavaType> types, TypeSubstitution substitution) {
        if (substitution.size() == 0 || types.isEmpty()) {
            return types;
        }
        ArrayList<JavaType> results = new ArrayList<JavaType>(types.size());
        for (JavaType type : types) {
            results.add(this.applySubstitution(type, substitution));
        }
        return results;
    }

    private JavaType applySubstitution(JavaType type, TypeSubstitution substitution) {
        JavaType substitutedType = substitution.substitutedType(type);
        if (substitutedType != null) {
            return substitutedType;
        }
        if (TypeSubstitutionSolver.isParametrizedType(type)) {
            return this.substituteInParametrizedType((JavaType.ParametrizedTypeJavaType)type, substitution);
        }
        if (type.isTagged(16)) {
            return this.substituteInWildCardType((JavaType.WildCardType)type, substitution);
        }
        if (type.isArray()) {
            return this.substituteInArrayType((JavaType.ArrayJavaType)type, substitution);
        }
        return type;
    }

    private static boolean isParametrizedType(JavaType type) {
        return type instanceof JavaType.ParametrizedTypeJavaType;
    }

    private JavaType substituteInParametrizedType(JavaType.ParametrizedTypeJavaType type, TypeSubstitution substitution) {
        TypeSubstitution newSubstitution = new TypeSubstitution();
        for (Map.Entry<JavaType.TypeVariableJavaType, JavaType> entry : type.typeSubstitution.substitutionEntries()) {
            newSubstitution.add(entry.getKey(), this.applySubstitution(entry.getValue(), substitution));
        }
        return this.parametrizedTypeCache.getParametrizedTypeType(type.rawType.getSymbol(), newSubstitution);
    }

    private JavaType substituteInWildCardType(JavaType.WildCardType wildcard, TypeSubstitution substitution) {
        JavaType substitutedType = this.applySubstitution(wildcard.bound, substitution);
        if (substitutedType != wildcard.bound) {
            return this.parametrizedTypeCache.getWildcardType(substitutedType, wildcard.boundType);
        }
        return wildcard;
    }

    private JavaType substituteInArrayType(JavaType.ArrayJavaType arrayType, TypeSubstitution substitution) {
        JavaType rootElementType = arrayType.elementType;
        int nbDimensions = 1;
        while (rootElementType.isArray()) {
            rootElementType = ((JavaType.ArrayJavaType)rootElementType).elementType;
            ++nbDimensions;
        }
        JavaType substitutedType = this.applySubstitution(rootElementType, substitution);
        if (substitutedType != rootElementType) {
            for (int i = 0; i < nbDimensions; ++i) {
                substitutedType = new JavaType.ArrayJavaType(substitutedType, this.symbols.arrayClass);
            }
            return substitutedType;
        }
        return arrayType;
    }

    TypeSubstitution getSubstitutionFromTypeParams(List<JavaType.TypeVariableJavaType> typeVariableTypes, List<JavaType> typeParams) {
        TypeSubstitution substitution = new TypeSubstitution();
        if (typeVariableTypes.size() == typeParams.size()) {
            for (int i = 0; i < typeVariableTypes.size(); ++i) {
                JavaType.TypeVariableJavaType typeVariableType = typeVariableTypes.get(i);
                JavaType typeParam = typeParams.get(i);
                substitution.add(typeVariableType, typeParam);
            }
        }
        return substitution;
    }

    private TypeSubstitution inferTypeSubstitution(JavaSymbol.MethodJavaSymbol method, List<JavaType> formals, List<JavaType> argTypes) {
        ArrayList<JavaType> remainingArgTypes;
        boolean variableArity;
        JavaType argType;
        JavaType formalType;
        boolean isVarArgs = method.isVarArgs();
        int numberFormals = formals.size();
        int numberArgs = argTypes.size();
        int numberParamToCheck = Math.min(numberFormals, numberArgs);
        ArrayList<JavaType> newArgTypes = new ArrayList<JavaType>(argTypes);
        TypeSubstitution substitution = new TypeSubstitution();
        if (isVarArgs && numberFormals == numberArgs + 1) {
            ++numberParamToCheck;
            newArgTypes.add(this.symbols.objectType);
        }
        for (int i = 0; i < numberParamToCheck && !(substitution = this.inferTypeSubstitution(method, substitution, formalType = formals.get(i), argType = (JavaType)newArgTypes.get(i), variableArity = isVarArgs && i == numberFormals - 1, remainingArgTypes = new ArrayList<JavaType>(newArgTypes.subList(i, newArgTypes.size())))).typeVariables().containsAll(method.typeVariableTypes); ++i) {
        }
        return substitution;
    }

    /*
     * WARNING - void declaration
     */
    private TypeSubstitution inferTypeSubstitution(JavaSymbol.MethodJavaSymbol method, TypeSubstitution currentSubstitution, JavaType formalType, JavaType argType, boolean variableArity, List<JavaType> remainingArgTypes) {
        if (formalType.isTagged(15)) {
            this.completeSubstitution(currentSubstitution, formalType, argType);
        } else if (formalType.isArray()) {
            JavaType newArgType = null;
            if (argType.isArray()) {
                newArgType = ((JavaType.ArrayJavaType)argType).elementType;
            } else if (variableArity) {
                newArgType = TypeSubstitutionSolver.leastUpperBound(remainingArgTypes);
            }
            if (newArgType != null) {
                JavaType formalElementType = ((JavaType.ArrayJavaType)formalType).elementType;
                TypeSubstitution typeSubstitution = this.inferTypeSubstitution(method, currentSubstitution, formalElementType, newArgType, variableArity, remainingArgTypes);
                return TypeSubstitutionSolver.mergeTypeSubstitutions(currentSubstitution, typeSubstitution);
            }
        } else if (TypeSubstitutionSolver.isParametrizedType(formalType)) {
            List<JavaType> formalTypeSubstitutedTypes = ((JavaType.ParametrizedTypeJavaType)formalType).typeSubstitution.substitutedTypes();
            if (TypeSubstitutionSolver.isParametrizedType(argType)) {
                List<JavaType> argTypeSubstitutedTypes = ((JavaType.ParametrizedTypeJavaType)argType).typeSubstitution.substitutedTypes();
                TypeSubstitution typeSubstitution = this.inferTypeSubstitution(method, formalTypeSubstitutedTypes, argTypeSubstitutedTypes);
                return TypeSubstitutionSolver.mergeTypeSubstitutions(currentSubstitution, typeSubstitution);
            }
            if (TypeSubstitutionSolver.isRawTypeOfType(argType, formalType) || this.isNullType(argType)) {
                void var9_17;
                ArrayList<JavaType> fakeTypes = new ArrayList<JavaType>(formalTypeSubstitutedTypes.size());
                boolean bl = false;
                while (var9_17 < formalTypeSubstitutedTypes.size()) {
                    fakeTypes.add(this.symbols.objectType);
                    ++var9_17;
                }
                TypeSubstitution typeSubstitution = this.inferTypeSubstitution(method, formalTypeSubstitutedTypes, fakeTypes);
                return TypeSubstitutionSolver.mergeTypeSubstitutions(currentSubstitution, typeSubstitution);
            }
            if (argType.isSubtypeOf(formalType.erasure()) && argType.isClass()) {
                for (JavaType javaType : ((JavaType.ClassJavaType)argType).symbol.superTypes()) {
                    if (!TypeSubstitutionSolver.sameErasure(formalType, javaType)) continue;
                    return this.inferTypeSubstitution(method, currentSubstitution, formalType, javaType, variableArity, remainingArgTypes);
                }
            }
        } else if (formalType.isTagged(16)) {
            TypeSubstitution newSubstitution = this.inferTypeSubstitution(method, currentSubstitution, ((JavaType.WildCardType)formalType).bound, argType, variableArity, remainingArgTypes);
            return TypeSubstitutionSolver.mergeTypeSubstitutions(currentSubstitution, newSubstitution);
        }
        return currentSubstitution;
    }

    private static JavaType leastUpperBound(List<JavaType> remainingArgTypes) {
        return (JavaType)Types.leastUpperBound(TypeSubstitutionSolver.mapToBoxedSet(remainingArgTypes));
    }

    private static Set<Type> mapToBoxedSet(List<JavaType> types) {
        return Sets.newHashSet((Iterable)Iterables.transform((Iterable)Sets.newHashSet(types), (Function)new Function<Type, Type>(){

            public Type apply(Type type) {
                if (type.isPrimitive()) {
                    return ((JavaType)type).primitiveWrapperType;
                }
                return type;
            }
        }));
    }

    private static boolean sameErasure(JavaType formalType, JavaType superType) {
        return formalType.erasure() == superType.erasure();
    }

    private boolean isNullType(JavaType argType) {
        return argType == this.symbols.nullType;
    }

    private static boolean isRawTypeOfType(JavaType argType, JavaType formalType) {
        return argType == formalType.erasure();
    }

    private static TypeSubstitution mergeTypeSubstitutions(TypeSubstitution currentSubstitution, TypeSubstitution newSubstitution) {
        TypeSubstitution result = new TypeSubstitution();
        for (Map.Entry<JavaType.TypeVariableJavaType, JavaType> substitution : currentSubstitution.substitutionEntries()) {
            result.add(substitution.getKey(), substitution.getValue());
        }
        for (Map.Entry<JavaType.TypeVariableJavaType, JavaType> substitution : newSubstitution.substitutionEntries()) {
            if (result.typeVariables().contains(substitution.getKey())) continue;
            result.add(substitution.getKey(), substitution.getValue());
        }
        return result;
    }

    private void completeSubstitution(TypeSubstitution currentSubstitution, JavaType formalType, JavaType argType) {
        if (formalType.isTagged(15) && currentSubstitution.substitutedType(formalType) == null) {
            JavaType expectedType = argType;
            if (expectedType.isPrimitive()) {
                expectedType = expectedType.primitiveWrapperType;
            } else if (this.isNullType(expectedType)) {
                expectedType = this.symbols.objectType;
            }
            JavaType.TypeVariableJavaType typeVar = (JavaType.TypeVariableJavaType)formalType;
            currentSubstitution.add(typeVar, expectedType);
        }
    }

    private boolean isValidSubtitution(TypeSubstitution substitutions, JavaType site) {
        for (Map.Entry<JavaType.TypeVariableJavaType, JavaType> substitution : substitutions.substitutionEntries()) {
            if (this.isValidSubstitution(substitutions, substitution.getKey(), substitution.getValue(), site)) continue;
            return false;
        }
        return true;
    }

    private boolean isValidSubstitution(TypeSubstitution candidate, JavaType.TypeVariableJavaType typeVar, JavaType typeParam, JavaType site) {
        for (JavaType bound : typeVar.bounds) {
            JavaType currentBound = this.applySubstitution(bound, candidate);
            while (currentBound.isTagged(15)) {
                JavaType newBound = candidate.substitutedType(currentBound);
                if (newBound == null && TypeSubstitutionSolver.isParametrizedType(site)) {
                    newBound = ((JavaType.ParametrizedTypeJavaType)site).typeSubstitution.substitutedType(currentBound);
                }
                if (newBound == null) {
                    return ((JavaSymbol.TypeJavaSymbol)site.symbol()).typeVariableTypes.contains(currentBound);
                }
                currentBound = newBound;
            }
            if (typeParam.isSubtypeOf(currentBound)) continue;
            return false;
        }
        return true;
    }
}

