/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.checks;

import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.MethodMatcherCollection;
import org.sonar.java.matcher.MethodMatcherFactory;
import org.sonar.java.se.CheckerContext;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.checks.CheckerTreeNodeVisitor;
import org.sonar.java.se.checks.SECheck;
import org.sonar.java.se.constraint.ConstraintManager;
import org.sonar.java.se.constraint.ObjectConstraint;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.NoSqale;
import org.sonar.squidbridge.annotations.RuleTemplate;

@Rule(key="S3546", name="Resources as defined by user should be closed", priority=Priority.CRITICAL, tags={"denial-of-service", "security"})
@RuleTemplate
@NoSqale
public class CustomUnclosedResourcesCheck
extends SECheck {
    private final Status status = new Status();
    @RuleProperty(key="constructor", description="the fully-qualified name of a constructor that creates an open resource. An optional signature may be specified after the class name. E.G. \"org.assoc.res.MyResource\" or \"org.assoc.res.MySpecialResource(java.lang.String, int)\"")
    public String constructor = "";
    @RuleProperty(key="factoryMethod", description="the fully-qualified name of a factory method that returns an open resource, with or without a parameter list. E.G. \"org.assoc.res.ResourceFactory$Innerclass#create\" or \"org.assoc.res.SpecialResourceFactory#create(java.lang.String, int)\"")
    public String factoryMethod = "";
    @RuleProperty(key="openingMethod", description="the fully-qualified name of a method that opens an existing resource, with or without a parameter list. E.G. \"org.assoc.res.ResourceFactory#create\" or \"org.assoc.res.SpecialResourceFactory #create(java.lang.String, int)\"")
    public String openingMethod = "";
    @RuleProperty(key="closingMethod", description="the fully-qualified name of the method which closes the open resource, with or without a parameter list. E.G. \"org.assoc.res.MyResource#closeMe\" or \"org.assoc.res.MySpecialResource#closeMe(java.lang.String, int)\"")
    public String closingMethod = "";
    private MethodMatcherCollection classConstructor;
    private MethodMatcherCollection factoryList;
    private MethodMatcherCollection openingList;
    private MethodMatcherCollection closingList;

    @Override
    public ProgramState checkPreStatement(CheckerContext context, Tree syntaxNode) {
        PreStatementVisitor visitor = new PreStatementVisitor(context);
        syntaxNode.accept(visitor);
        return visitor.programState;
    }

    @Override
    public ProgramState checkPostStatement(CheckerContext context, Tree syntaxNode) {
        PostStatementVisitor visitor = new PostStatementVisitor(context);
        syntaxNode.accept(visitor);
        return visitor.programState;
    }

    @Override
    public void checkEndOfExecutionPath(CheckerContext context, ConstraintManager constraintManager) {
        List<ObjectConstraint> constraints = context.getState().getFieldConstraints(this.status.OPENED);
        for (ObjectConstraint constraint : constraints) {
            Tree syntaxNode = constraint.syntaxNode();
            String name = null;
            if (syntaxNode.is(Tree.Kind.NEW_CLASS)) {
                name = ((NewClassTree)syntaxNode).identifier().symbolType().name();
            } else if (syntaxNode.is(Tree.Kind.METHOD_INVOCATION)) {
                name = ((MethodInvocationTree)syntaxNode).symbolType().name();
            }
            if (name == null) continue;
            context.reportIssue(syntaxNode, this, "Close this \"" + name + "\".");
        }
    }

    private static MethodMatcherCollection createMethodMatchers(String rule) {
        if (rule.length() > 0) {
            return MethodMatcherCollection.create(MethodMatcherFactory.methodMatcher(rule));
        }
        return MethodMatcherCollection.create(new MethodMatcher[0]);
    }

    private class PostStatementVisitor
    extends AbstractStatementVisitor {
        protected PostStatementVisitor(CheckerContext context) {
            super(context.getState());
        }

        @Override
        public void visitNewClass(NewClassTree newClassTree) {
            if (this.isCreatingResource(newClassTree)) {
                this.openResource(newClassTree);
            }
        }

        @Override
        public void visitMethodInvocation(MethodInvocationTree mit) {
            if (this.isCreatingResource(mit)) {
                this.openResource(mit);
            }
        }

        private boolean isCreatingResource(NewClassTree newClassTree) {
            return this.constructorClasses().anyMatch(newClassTree);
        }

        private MethodMatcherCollection constructorClasses() {
            if (CustomUnclosedResourcesCheck.this.classConstructor == null) {
                CustomUnclosedResourcesCheck.this.classConstructor = MethodMatcherCollection.create(new MethodMatcher[0]);
                if (CustomUnclosedResourcesCheck.this.constructor.length() > 0) {
                    CustomUnclosedResourcesCheck.this.classConstructor.add(MethodMatcherFactory.constructorMatcher(CustomUnclosedResourcesCheck.this.constructor));
                }
            }
            return CustomUnclosedResourcesCheck.this.classConstructor;
        }

        private boolean isCreatingResource(MethodInvocationTree mit) {
            return this.factoryMethods().anyMatch(mit);
        }

        private MethodMatcherCollection factoryMethods() {
            if (CustomUnclosedResourcesCheck.this.factoryList == null) {
                CustomUnclosedResourcesCheck.this.factoryList = CustomUnclosedResourcesCheck.createMethodMatchers(CustomUnclosedResourcesCheck.this.factoryMethod);
            }
            return CustomUnclosedResourcesCheck.this.factoryList;
        }
    }

    private class PreStatementVisitor
    extends AbstractStatementVisitor {
        protected PreStatementVisitor(CheckerContext context) {
            super(context.getState());
        }

        @Override
        public void visitNewClass(NewClassTree syntaxNode) {
            this.closeArguments(syntaxNode.arguments(), 0);
        }

        @Override
        public void visitMethodInvocation(MethodInvocationTree mit) {
            if (this.isOpeningResource(mit)) {
                this.openResource(mit);
            } else if (this.isClosingResource(mit)) {
                this.closeResource(this.programState.peekValue());
            } else {
                this.closeArguments(mit.arguments(), 1);
            }
        }

        private boolean isOpeningResource(MethodInvocationTree syntaxNode) {
            return this.openingMethods().anyMatch(syntaxNode);
        }

        @Override
        public void visitReturnStatement(ReturnStatementTree syntaxNode) {
            ExpressionTree expression = syntaxNode.expression();
            if (expression != null) {
                this.closeResource(this.programState.peekValue());
            }
        }

        private void closeArguments(Arguments arguments, int stackOffset) {
            List<SymbolicValue> values = this.programState.peekValues(arguments.size() + stackOffset);
            List<SymbolicValue> argumentValues = values.subList(stackOffset, values.size());
            for (SymbolicValue target : argumentValues) {
                this.closeResource(target);
            }
        }

        private MethodMatcherCollection openingMethods() {
            if (CustomUnclosedResourcesCheck.this.openingList == null) {
                CustomUnclosedResourcesCheck.this.openingList = CustomUnclosedResourcesCheck.createMethodMatchers(CustomUnclosedResourcesCheck.this.openingMethod);
            }
            return CustomUnclosedResourcesCheck.this.openingList;
        }
    }

    private abstract class AbstractStatementVisitor
    extends CheckerTreeNodeVisitor {
        protected AbstractStatementVisitor(ProgramState programState) {
            super(programState);
        }

        protected void closeResource(@Nullable SymbolicValue target) {
            ObjectConstraint oConstraint;
            if (target != null && (oConstraint = this.programState.getConstraintWithStatus(target, ((CustomUnclosedResourcesCheck)CustomUnclosedResourcesCheck.this).status.OPENED)) != null) {
                this.programState = this.programState.addConstraint(target.wrappedValue(), oConstraint.withStatus(((CustomUnclosedResourcesCheck)CustomUnclosedResourcesCheck.this).status.CLOSED));
            }
        }

        protected void openResource(Tree syntaxNode) {
            SymbolicValue sv = this.programState.peekValue();
            this.programState = this.programState.addConstraint(sv, new ObjectConstraint(false, false, syntaxNode, ((CustomUnclosedResourcesCheck)CustomUnclosedResourcesCheck.this).status.OPENED));
        }

        protected boolean isClosingResource(MethodInvocationTree mit) {
            return this.closingMethods().anyMatch(mit);
        }

        private MethodMatcherCollection closingMethods() {
            if (CustomUnclosedResourcesCheck.this.closingList == null) {
                CustomUnclosedResourcesCheck.this.closingList = CustomUnclosedResourcesCheck.createMethodMatchers(CustomUnclosedResourcesCheck.this.closingMethod);
            }
            return CustomUnclosedResourcesCheck.this.closingList;
        }
    }

    class Status {
        Object OPENED = new Object();
        Object CLOSED = new Object();

        Status() {
        }
    }
}

