/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.checks;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.cfg.CFG;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.java.resolve.Scope;
import org.sonar.java.se.CheckerContext;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.checks.CheckerTreeNodeVisitor;
import org.sonar.java.se.checks.SECheck;
import org.sonar.java.se.constraint.Constraint;
import org.sonar.java.se.constraint.ConstraintManager;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2637", name="\"@NonNull\" values should not be set to null", priority=Priority.CRITICAL, tags={"bug", "misra"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="RELIABILITY_COMPLIANCE")
@SqaleConstantRemediation(value="15min")
public class NonNullSetToNullCheck
extends SECheck {
    private static final String[] ANNOTATIONS = new String[]{"javax.annotation.Nonnull", "javax.validation.constraints.NotNull", "edu.umd.cs.findbugs.annotations.NonNull", "org.jetbrains.annotations.NotNull", "lombok.NonNull", "android.support.annotation.NonNull"};
    private MethodTree methodTree;

    @Override
    public void init(MethodTree tree, CFG cfg) {
        this.methodTree = tree;
    }

    @Override
    public ProgramState checkPreStatement(CheckerContext context, Tree syntaxNode) {
        PreStatementVisitor visitor = new PreStatementVisitor(context);
        syntaxNode.accept(visitor);
        return visitor.programState;
    }

    @Override
    public ProgramState checkPostStatement(CheckerContext context, Tree syntaxNode) {
        PostStatementVisitor visitor = new PostStatementVisitor(context);
        syntaxNode.accept(visitor);
        return visitor.programState;
    }

    @Override
    public void checkEndOfExecutionPath(CheckerContext context, ConstraintManager constraintManager) {
        if (this.methodTree.is(Tree.Kind.CONSTRUCTOR)) {
            ClassTree classTree = (ClassTree)this.methodTree.parent();
            for (Tree member : classTree.members()) {
                if (!member.is(Tree.Kind.VARIABLE)) continue;
                this.checkVariable(context, this.methodTree, ((VariableTree)member).symbol());
            }
        }
    }

    private void checkVariable(CheckerContext context, MethodTree tree, Symbol symbol) {
        String nonNullAnnotation = NonNullSetToNullCheck.nonNullAnnotation(symbol);
        if (nonNullAnnotation != null && NonNullSetToNullCheck.isUndefinedOrNull(context, symbol)) {
            context.reportIssue(tree, this, MessageFormat.format("\"{0}\" is marked \"{1}\" but is not initialized in this constructor.", symbol.name(), nonNullAnnotation));
        }
    }

    private static boolean isUndefinedOrNull(CheckerContext context, Symbol symbol) {
        ProgramState programState = context.getState();
        SymbolicValue value = programState.getValue(symbol);
        return value == null;
    }

    @CheckForNull
    private static String nonNullAnnotation(Symbol javaSymbol) {
        for (String annotation : ANNOTATIONS) {
            if (!javaSymbol.metadata().isAnnotatedWith(annotation)) continue;
            return annotation;
        }
        return null;
    }

    private class PostStatementVisitor
    extends AbstractStatementVisitor {
        protected PostStatementVisitor(CheckerContext context) {
            super(context);
        }

        @Override
        public void visitReturnStatement(ReturnStatementTree tree) {
            Tree parent = tree.parent();
            while (!parent.is(Tree.Kind.METHOD)) {
                if ((parent = parent.parent()) != null) continue;
                return;
            }
            MethodTree mTree = (MethodTree)parent;
            String nonNullAnnotation = NonNullSetToNullCheck.nonNullAnnotation(mTree.symbol());
            if (nonNullAnnotation != null && this.isLocalExpression(tree.expression())) {
                this.checkReturnedValue(tree, nonNullAnnotation);
            }
        }

        private boolean isLocalExpression(ExpressionTree expression) {
            if (expression.is(Tree.Kind.IDENTIFIER)) {
                Symbol symbol = ((IdentifierTree)expression).symbol().owner();
                return symbol.isMethodSymbol();
            }
            return true;
        }

        private void checkReturnedValue(ReturnStatementTree tree, String nonNullAnnotation) {
            SymbolicValue returnedValue = this.programState.peekValue();
            Constraint constraint = this.programState.getConstraint(returnedValue);
            if (constraint != null && constraint.isNull()) {
                this.reportIssue(tree, "This method''s return value is marked \"{0}\" but null is returned.", nonNullAnnotation);
            }
        }
    }

    private class PreStatementVisitor
    extends AbstractStatementVisitor {
        protected PreStatementVisitor(CheckerContext context) {
            super(context);
        }

        @Override
        public void visitAssignmentExpression(AssignmentExpressionTree tree) {
            List<SymbolicValue> values;
            SymbolicValue assignedValue;
            Constraint constraint;
            IdentifierTree variable;
            Symbol symbol;
            String nonNullAnnotation;
            if (tree.variable().is(Tree.Kind.IDENTIFIER) && (nonNullAnnotation = NonNullSetToNullCheck.nonNullAnnotation(symbol = (variable = (IdentifierTree)tree.variable()).symbol())) != null && (constraint = this.programState.getConstraint(assignedValue = (values = this.programState.peekValues(2)).get(1))) != null && constraint.isNull()) {
                this.reportIssue(tree, "\"{0}\" is marked \"{1}\" but is set to null.", symbol.name(), nonNullAnnotation);
            }
        }

        @Override
        public void visitNewClass(NewClassTree syntaxTree) {
            Symbol symbol = syntaxTree.constructorSymbol();
            if (symbol.isMethodSymbol()) {
                List<SymbolicValue> argumentValues = this.programState.peekValues(syntaxTree.arguments().size());
                JavaSymbol.MethodJavaSymbol methodSymbol = (JavaSymbol.MethodJavaSymbol)symbol;
                this.checkNullArguments(syntaxTree, methodSymbol.getParameters(), argumentValues, "Parameter {0} to this constructor is marked \"{1}\" but null is passed.");
            }
        }

        @Override
        public void visitMethodInvocation(MethodInvocationTree syntaxTree) {
            Symbol symbol = syntaxTree.symbol();
            if (symbol.isMethodSymbol()) {
                Arguments arguments = syntaxTree.arguments();
                ArrayList<SymbolicValue> argumentValues = new ArrayList<SymbolicValue>(this.programState.peekValues(arguments.size() + 1));
                argumentValues.remove(0);
                Collections.reverse(argumentValues);
                JavaSymbol.MethodJavaSymbol methodSymbol = (JavaSymbol.MethodJavaSymbol)symbol;
                this.checkNullArguments(syntaxTree, methodSymbol.getParameters(), argumentValues, "Parameter {0} to this call is marked \"{1}\" but null is passed.");
            }
        }

        protected void checkNullArguments(Tree syntaxTree, Scope parameters, List<SymbolicValue> argumentValues, String message) {
            if (parameters != null) {
                List<JavaSymbol> scopeSymbols = parameters.scopeSymbols();
                int parametersToTest = argumentValues.size();
                if (scopeSymbols.size() < parametersToTest) {
                    parametersToTest = scopeSymbols.size() - 1;
                }
                for (int i = 0; i < parametersToTest; ++i) {
                    this.checkNullArgument(syntaxTree, message, scopeSymbols, argumentValues, i);
                }
            }
        }

        protected void checkNullArgument(Tree syntaxTree, String message, List<JavaSymbol> scopeSymbols, List<SymbolicValue> argumentValues, int i) {
            Constraint constraint;
            String nonNullAnnotation = NonNullSetToNullCheck.nonNullAnnotation(scopeSymbols.get(i));
            if (nonNullAnnotation != null && (constraint = this.programState.getConstraint(argumentValues.get(i))) != null && constraint.isNull()) {
                this.reportIssue(syntaxTree, message, i + 1, nonNullAnnotation);
            }
        }
    }

    private abstract class AbstractStatementVisitor
    extends CheckerTreeNodeVisitor {
        private final CheckerContext context;

        protected AbstractStatementVisitor(CheckerContext context) {
            super(context.getState());
            this.context = context;
        }

        protected void reportIssue(Tree tree, String message, Object ... parameters) {
            this.context.reportIssue(tree, NonNullSetToNullCheck.this, MessageFormat.format(message, parameters));
        }
    }
}

