/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.matcher;

import org.sonar.plugins.java.api.semantic.Type;

public abstract class TypeCriteria {
    public static TypeCriteria subtypeOf(String fullyQualifiedName) {
        return new SubtypeTypeCriteria(fullyQualifiedName);
    }

    public static TypeCriteria is(String fullyQualifiedName) {
        return new FullyQualifiedNameTypeCriteria(fullyQualifiedName);
    }

    public static TypeCriteria anyType() {
        return new AnyTypeCriteria();
    }

    public abstract boolean matches(Type var1);

    private static class AnyTypeCriteria
    extends TypeCriteria {
        private AnyTypeCriteria() {
        }

        @Override
        public boolean matches(Type type) {
            return true;
        }
    }

    private static class SubtypeTypeCriteria
    extends TypeCriteria {
        private String superTypeName;

        public SubtypeTypeCriteria(String superTypeName) {
            this.superTypeName = superTypeName;
        }

        @Override
        public boolean matches(Type type) {
            return type.isSubtypeOf(this.superTypeName);
        }
    }

    private static class FullyQualifiedNameTypeCriteria
    extends TypeCriteria {
        private String fullyQualifiedName;

        public FullyQualifiedNameTypeCriteria(String fullyQualifiedName) {
            this.fullyQualifiedName = fullyQualifiedName;
        }

        @Override
        public boolean matches(Type type) {
            return type.is(this.fullyQualifiedName);
        }
    }
}

