/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.java.resolve.ClassJavaType;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.java.resolve.JavaType;
import org.sonar.java.resolve.TypeSubstitution;
import org.sonar.java.resolve.TypeVariableJavaType;
import org.sonar.java.resolve.WildCardType;
import org.sonar.plugins.java.api.semantic.Type;

public class ParametrizedTypeJavaType
extends ClassJavaType {
    final TypeSubstitution typeSubstitution;
    final JavaType rawType;

    ParametrizedTypeJavaType(JavaSymbol.TypeJavaSymbol symbol, TypeSubstitution typeSubstitution) {
        super(18, symbol);
        this.rawType = symbol.getType();
        this.typeSubstitution = typeSubstitution;
    }

    @Override
    public JavaType erasure() {
        return this.rawType.erasure();
    }

    @Nullable
    public JavaType substitution(TypeVariableJavaType typeVariableType) {
        JavaType result = null;
        if (this.typeSubstitution != null) {
            result = this.typeSubstitution.substitutedType(typeVariableType);
        }
        return result;
    }

    public List<TypeVariableJavaType> typeParameters() {
        if (this.typeSubstitution != null) {
            return this.typeSubstitution.typeVariables();
        }
        return Lists.newArrayList();
    }

    @Override
    public boolean isSubtypeOf(Type superType) {
        if (((JavaType)superType).isTagged(15)) {
            return false;
        }
        if (this.erasure().isSubtypeOf(superType.erasure())) {
            boolean superTypeIsParametrizedJavaType = ((JavaType)superType).isParameterized();
            if (superTypeIsParametrizedJavaType) {
                return this.checkSubstitutedTypesCompatibility((ParametrizedTypeJavaType)superType);
            }
            return !superTypeIsParametrizedJavaType;
        }
        if (((JavaType)superType).isTagged(16)) {
            return ((WildCardType)superType).isSubtypeOfBound(this);
        }
        return false;
    }

    private boolean checkSubstitutedTypesCompatibility(ParametrizedTypeJavaType superType) {
        List<JavaType> myTypes = this.typeSubstitution.substitutedTypes();
        List<JavaType> itsTypes = superType.typeSubstitution.substitutedTypes();
        if (itsTypes.size() != myTypes.size()) {
            return false;
        }
        for (int i = 0; i < myTypes.size(); ++i) {
            JavaType myType = myTypes.get(i);
            JavaType itsType = itsTypes.get(i);
            if (!(itsType.isTagged(16) ? !myType.isSubtypeOf(itsType) : !myType.equals(itsType))) continue;
            return false;
        }
        return true;
    }
}

