/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.sonar.java.resolve.JavaType;
import org.sonar.java.resolve.TypeVariableJavaType;

public class TypeSubstitution {
    private Map<TypeVariableJavaType, JavaType> substitutions = Maps.newLinkedHashMap();

    public TypeSubstitution() {
    }

    public TypeSubstitution(TypeSubstitution typeSubstitution) {
        this.substitutions = Maps.newLinkedHashMap(typeSubstitution.substitutions);
    }

    @CheckForNull
    public JavaType substitutedType(JavaType javaType) {
        return this.substitutions.get(javaType);
    }

    public List<TypeVariableJavaType> typeVariables() {
        return Lists.newArrayList(this.substitutions.keySet());
    }

    public List<Map.Entry<TypeVariableJavaType, JavaType>> substitutionEntries() {
        return Lists.newArrayList(this.substitutions.entrySet());
    }

    public List<JavaType> substitutedTypes() {
        return Lists.newArrayList(this.substitutions.values());
    }

    public TypeSubstitution add(TypeVariableJavaType typeVariableType, JavaType javaType) {
        this.substitutions.put(typeVariableType, javaType);
        return this;
    }

    public int size() {
        return this.substitutions.size();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TypeSubstitution newSubstitution = (TypeSubstitution)obj;
        return this.substitutions.equals(newSubstitution.substitutions) && this.substitutionEntries().equals(newSubstitution.substitutionEntries());
    }

    public int hashCode() {
        return this.substitutionEntries().hashCode();
    }

    public boolean isIdentity() {
        for (Map.Entry<TypeVariableJavaType, JavaType> substitution : this.substitutionEntries()) {
            if (substitution.getKey() == substitution.getValue()) continue;
            return false;
        }
        return true;
    }

    public TypeSubstitution combine(TypeSubstitution source) {
        TypeSubstitution result = new TypeSubstitution();
        for (Map.Entry<TypeVariableJavaType, JavaType> substitution : this.substitutionEntries()) {
            TypeVariableJavaType typeVar = substitution.getKey();
            JavaType targetType = substitution.getValue();
            if (source.substitutedType(typeVar) != null && targetType.isTagged(15)) {
                result.add((TypeVariableJavaType)targetType, source.substitutedType(typeVar));
                continue;
            }
            result.add(typeVar, targetType);
        }
        return result;
    }
}

