/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.sonar.java.resolve.ArrayJavaType;
import org.sonar.java.resolve.JavaType;
import org.sonar.java.resolve.Symbols;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;

public class Types {
    public boolean isSubtype(JavaType t, JavaType s) {
        boolean result;
        if (t == s) {
            result = true;
        } else {
            switch (t.tag) {
                case 1: 
                case 2: {
                    result = t.tag == s.tag || t.tag + 2 <= s.tag && s.tag <= 7;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    result = t.tag <= s.tag && s.tag <= 7;
                    break;
                }
                case 8: 
                case 9: {
                    result = t.tag == s.tag;
                    break;
                }
                case 11: {
                    if (t.tag != s.tag) {
                        result = t.getSymbol().getSuperclass() == s;
                        break;
                    }
                    result = this.isSubtype(((ArrayJavaType)t).elementType(), ((ArrayJavaType)s).elementType());
                    break;
                }
                case 10: 
                case 15: 
                case 16: 
                case 18: {
                    result = t.isSubtypeOf(s);
                    break;
                }
                case 13: {
                    result = s.tag == 13 || s.tag == 10 || s.tag == 11;
                    break;
                }
                default: {
                    result = false;
                }
            }
        }
        return result;
    }

    public static Type leastUpperBound(Set<Type> types) {
        List<Set<Type>> supertypes;
        List<Type> candidates;
        List<Type> minimalCandidates;
        Preconditions.checkArgument((!types.isEmpty() ? 1 : 0) != 0);
        Iterator<Type> iterator = types.iterator();
        Type first = iterator.next();
        if (types.size() == 1) {
            return first;
        }
        if (types.size() == 2) {
            Type type2 = iterator.next();
            if (first.isSubtypeOf(type2)) {
                return type2;
            }
            if (type2.isSubtypeOf(first)) {
                return first;
            }
        }
        if ((minimalCandidates = Types.minimalCandidates(candidates = Types.intersection(supertypes = Types.supertypes(types)))).isEmpty()) {
            return Symbols.unknownType;
        }
        return Types.best(minimalCandidates);
    }

    @VisibleForTesting
    static Type best(List<Type> minimalCandidates) {
        Collections.sort(minimalCandidates, new Comparator<Type>(){

            @Override
            public int compare(Type type, Type t1) {
                Symbol.TypeSymbol typeSymbol = type.symbol();
                Symbol.TypeSymbol t1Symbol = t1.symbol();
                if (typeSymbol.isInterface() && t1Symbol.isInterface()) {
                    return type.name().compareTo(t1.name());
                }
                if (typeSymbol.isInterface()) {
                    return 1;
                }
                if (t1Symbol.isInterface()) {
                    return -1;
                }
                return type.name().compareTo(t1.name());
            }
        });
        return minimalCandidates.get(0);
    }

    private static List<Set<Type>> supertypes(Iterable<Type> types) {
        LinkedList<Set<Type>> results = new LinkedList<Set<Type>>();
        for (Type type : types) {
            LinkedHashSet<Type> supertypes = new LinkedHashSet<Type>();
            supertypes.add(type.erasure());
            for (Type type2 : ((JavaType)type).symbol.superTypes()) {
                supertypes.add(type2.erasure());
            }
            results.add(supertypes);
        }
        return results;
    }

    private static List<Type> intersection(List<Set<Type>> supertypes) {
        LinkedList<Type> results = new LinkedList<Type>((Collection)supertypes.get(0));
        for (int i = 1; i < supertypes.size(); ++i) {
            results.retainAll((Collection)supertypes.get(i));
        }
        return results;
    }

    private static List<Type> minimalCandidates(List<Type> erasedCandidates) {
        LinkedList<Type> results = new LinkedList<Type>();
        for (Type v : erasedCandidates) {
            boolean isValid = true;
            for (Type w : erasedCandidates) {
                if (w.equals(v) || !w.isSubtypeOf(v)) continue;
                isValid = false;
                break;
            }
            if (!isValid) continue;
            results.add(v);
        }
        return results;
    }
}

