/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se;

import com.google.common.collect.Lists;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.java.ast.visitors.SubscriptionVisitor;
import org.sonar.java.se.ExplodedGraphWalker;
import org.sonar.java.se.symbolicvalues.BinaryRelation;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.tree.Tree;

public class SymbolicExecutionVisitor
extends SubscriptionVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(SymbolicExecutionVisitor.class);
    private final ExplodedGraphWalker.ExplodedGraphWalkerFactory egwFactory;

    public SymbolicExecutionVisitor(List<JavaFileScanner> executableScanners) {
        this.egwFactory = new ExplodedGraphWalker.ExplodedGraphWalkerFactory(executableScanners);
    }

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Lists.newArrayList((Object[])new Tree.Kind[]{Tree.Kind.METHOD, Tree.Kind.CONSTRUCTOR});
    }

    @Override
    public void visitNode(Tree tree) {
        try {
            tree.accept(this.egwFactory.createWalker());
        }
        catch (ExplodedGraphWalker.ExplodedGraphTooBigException | ExplodedGraphWalker.MaximumStepsReachedException | BinaryRelation.TransitiveRelationExceededException exception) {
            LOG.debug("Could not complete symbolic execution: ", (Throwable)exception);
        }
    }
}

