/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.checks;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.se.CheckerContext;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.SymbolicValueFactory;
import org.sonar.java.se.checks.CheckerTreeNodeVisitor;
import org.sonar.java.se.checks.SECheck;
import org.sonar.java.se.constraint.ConstraintManager;
import org.sonar.java.se.constraint.ObjectConstraint;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TryStatementTree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2095")
public class UnclosedResourcesCheck
extends SECheck {
    private static final String JAVA_IO_AUTO_CLOSEABLE = "java.lang.AutoCloseable";
    private static final String JAVA_IO_CLOSEABLE = "java.io.Closeable";
    private static final String JAVA_SQL_STATEMENT = "java.sql.Statement";
    private static final String[] JDBC_RESOURCE_CREATIONS = new String[]{"java.sql.Connection", "java.sql.Statement"};
    private static final String STREAM_TOP_HIERARCHY = "java.util.stream.BaseStream";
    private static final String[] IGNORED_CLOSEABLE_SUBTYPES = new String[]{"java.io.ByteArrayOutputStream", "java.io.ByteArrayInputStream", "java.io.CharArrayReader", "java.io.CharArrayWriter", "java.io.StringReader", "java.io.StringWriter", "com.sun.org.apache.xml.internal.security.utils.UnsyncByteArrayOutputStream"};
    private static final MethodMatcher[] CLOSEABLE_EXCEPTIONS = new MethodMatcher[]{MethodMatcher.create().typeDefinition("java.nio.file.FileSystems").name("getDefault")};

    @Override
    public ProgramState checkPreStatement(CheckerContext context, Tree syntaxNode) {
        PreStatementVisitor visitor = new PreStatementVisitor(context);
        syntaxNode.accept(visitor);
        return visitor.programState;
    }

    @Override
    public ProgramState checkPostStatement(CheckerContext context, Tree syntaxNode) {
        PostStatementVisitor visitor = new PostStatementVisitor(context);
        syntaxNode.accept(visitor);
        return visitor.programState;
    }

    @Override
    public void checkEndOfExecutionPath(CheckerContext context, ConstraintManager constraintManager) {
        List<ObjectConstraint> constraints = context.getState().getFieldConstraints((Object)Status.OPENED);
        for (ObjectConstraint constraint : constraints) {
            Tree syntaxNode = constraint.syntaxNode();
            String name = null;
            if (syntaxNode.is(Tree.Kind.NEW_CLASS)) {
                name = ((NewClassTree)syntaxNode).identifier().symbolType().name();
            } else if (syntaxNode.is(Tree.Kind.METHOD_INVOCATION)) {
                name = ((MethodInvocationTree)syntaxNode).symbolType().name();
            }
            if (name == null) continue;
            context.reportIssue(syntaxNode, this, "Close this \"" + name + "\".");
        }
    }

    private static boolean needsClosing(Type type) {
        if (type.isSubtypeOf(STREAM_TOP_HIERARCHY)) {
            return false;
        }
        for (String ignoredTypes : IGNORED_CLOSEABLE_SUBTYPES) {
            if (!type.is(ignoredTypes)) continue;
            return false;
        }
        return UnclosedResourcesCheck.isCloseable(type);
    }

    private static boolean isCloseable(Type type) {
        return type.isSubtypeOf(JAVA_IO_AUTO_CLOSEABLE) || type.isSubtypeOf(JAVA_IO_CLOSEABLE);
    }

    private static boolean isOpeningResource(NewClassTree syntaxNode) {
        if (UnclosedResourcesCheck.isWithinTryHeader(syntaxNode)) {
            return false;
        }
        return UnclosedResourcesCheck.needsClosing(syntaxNode.symbolType());
    }

    private static boolean isWithinTryHeader(Tree syntaxNode) {
        Tree parent = syntaxNode.parent();
        if (parent.is(Tree.Kind.VARIABLE)) {
            return UnclosedResourcesCheck.isTryStatementResource((VariableTree)parent);
        }
        return false;
    }

    private static boolean isTryStatementResource(VariableTree variable) {
        TryStatementTree tryStatement = UnclosedResourcesCheck.getEnclosingTryStatement(variable);
        return tryStatement != null && tryStatement.resources().contains(variable);
    }

    private static TryStatementTree getEnclosingTryStatement(Tree syntaxNode) {
        for (Tree parent = syntaxNode.parent(); parent != null; parent = parent.parent()) {
            if (!parent.is(Tree.Kind.TRY_STATEMENT)) continue;
            return (TryStatementTree)parent;
        }
        return null;
    }

    private static class PostStatementVisitor
    extends CheckerTreeNodeVisitor {
        PostStatementVisitor(CheckerContext context) {
            super(context.getState());
        }

        @Override
        public void visitNewClass(NewClassTree syntaxNode) {
            SymbolicValue instanceValue;
            if (UnclosedResourcesCheck.isOpeningResource(syntaxNode) && !((instanceValue = this.programState.peekValue()) instanceof ResourceWrapperSymbolicValue)) {
                this.programState = this.programState.addConstraint(instanceValue, new ObjectConstraint(false, false, syntaxNode, (Object)Status.OPENED));
            }
        }

        @Override
        public void visitMethodInvocation(MethodInvocationTree syntaxNode) {
            ExpressionTree targetExpression;
            for (MethodMatcher matcher : CLOSEABLE_EXCEPTIONS) {
                if (!matcher.matches(syntaxNode)) continue;
                return;
            }
            if (syntaxNode.methodSelect().is(Tree.Kind.MEMBER_SELECT) && UnclosedResourcesCheck.needsClosing(syntaxNode.symbolType()) && (targetExpression = ((MemberSelectExpressionTree)syntaxNode.methodSelect()).expression()).is(Tree.Kind.IDENTIFIER) && !UnclosedResourcesCheck.isWithinTryHeader(syntaxNode) && (syntaxNode.symbol().isStatic() || PostStatementVisitor.isJdbcResourceCreation(targetExpression))) {
                this.programState = this.programState.addConstraint(this.programState.peekValue(), new ObjectConstraint(false, false, syntaxNode, (Object)Status.OPENED));
            }
        }

        private static boolean isJdbcResourceCreation(ExpressionTree targetExpression) {
            for (String creator : JDBC_RESOURCE_CREATIONS) {
                if (!targetExpression.symbolType().is(creator)) continue;
                return true;
            }
            return false;
        }
    }

    private static class PreStatementVisitor
    extends CheckerTreeNodeVisitor {
        private static final String CLOSE_METHOD_NAME = "close";
        private static final String GET_MORE_RESULTS_METHOD_NAME = "getMoreResults";
        private static final String GET_RESULT_SET = "getResultSet";
        private final ConstraintManager constraintManager;

        PreStatementVisitor(CheckerContext context) {
            super(context.getState());
            this.constraintManager = context.getConstraintManager();
        }

        @Override
        public void visitNewClass(NewClassTree syntaxNode) {
            List<SymbolicValue> arguments = this.programState.peekValues(syntaxNode.arguments().size());
            if (UnclosedResourcesCheck.isOpeningResource(syntaxNode)) {
                Iterator<SymbolicValue> iterator = arguments.iterator();
                for (ExpressionTree argument : syntaxNode.arguments()) {
                    if (!iterator.hasNext()) {
                        throw new IllegalStateException("Mismatch between declared constructor arguments and argument values!");
                    }
                    Type type = argument.symbolType();
                    SymbolicValue value = iterator.next();
                    if (!UnclosedResourcesCheck.isCloseable(type)) continue;
                    this.constraintManager.setValueFactory(new WrappedValueFactory(value));
                    break;
                }
            } else {
                this.closeArguments(syntaxNode.arguments(), 0);
            }
        }

        @Override
        public void visitReturnStatement(ReturnStatementTree syntaxNode) {
            ExpressionTree expression;
            SymbolicValue currentVal = this.programState.peekValue();
            if (currentVal != null && (expression = syntaxNode.expression()) != null) {
                if (expression.is(Tree.Kind.IDENTIFIER)) {
                    IdentifierTree identifier = (IdentifierTree)expression;
                    currentVal = this.programState.getValue(identifier.symbol());
                } else {
                    currentVal = this.programState.peekValue();
                }
                this.closeResource(currentVal);
            }
        }

        @Override
        public void visitAssignmentExpression(AssignmentExpressionTree syntaxNode) {
            ExpressionTree variable = syntaxNode.variable();
            if (PreStatementVisitor.isNonLocalStorage(variable)) {
                List<SymbolicValue> stackedValues = this.programState.peekValues(2);
                SymbolicValue value = stackedValues.get(1);
                this.closeResource(value);
            }
        }

        private static boolean isNonLocalStorage(ExpressionTree variable) {
            if (variable.is(Tree.Kind.IDENTIFIER)) {
                Symbol owner = ((IdentifierTree)variable).symbol().owner();
                return !owner.isMethodSymbol();
            }
            return true;
        }

        @Override
        public void visitMethodInvocation(MethodInvocationTree syntaxNode) {
            ExpressionTree methodSelect = syntaxNode.methodSelect();
            if (PreStatementVisitor.isClosingResource(syntaxNode.symbol())) {
                if (methodSelect.is(Tree.Kind.MEMBER_SELECT)) {
                    ExpressionTree targetExpression = ((MemberSelectExpressionTree)methodSelect).expression();
                    if (targetExpression.is(Tree.Kind.IDENTIFIER)) {
                        IdentifierTree identifier = (IdentifierTree)targetExpression;
                        this.closeResource(this.programState.getValue(identifier.symbol()));
                    } else {
                        this.closeResource(this.programState.peekValue());
                    }
                }
            } else if (syntaxNode.methodSelect().is(Tree.Kind.MEMBER_SELECT) && PreStatementVisitor.isOpeningResultSet(syntaxNode.symbol())) {
                SymbolicValue value = this.getTargetValue(syntaxNode);
                this.constraintManager.setValueFactory(new WrappedValueFactory(value));
            } else if (PreStatementVisitor.isClosingResultSets(syntaxNode.symbol())) {
                if (methodSelect.is(Tree.Kind.MEMBER_SELECT)) {
                    SymbolicValue value = this.getTargetValue(syntaxNode);
                    this.closeResultSetsRelatedTo(value);
                }
            } else {
                this.closeArguments(syntaxNode.arguments(), 1);
            }
        }

        private SymbolicValue getTargetValue(MethodInvocationTree syntaxNode) {
            SymbolicValue value;
            ExpressionTree targetExpression = ((MemberSelectExpressionTree)syntaxNode.methodSelect()).expression();
            if (targetExpression.is(Tree.Kind.IDENTIFIER)) {
                IdentifierTree identifier = (IdentifierTree)targetExpression;
                value = this.programState.getValue(identifier.symbol());
            } else {
                value = this.programState.peekValue();
            }
            return value;
        }

        private void closeResultSetsRelatedTo(SymbolicValue value) {
            for (Map.Entry<SymbolicValue, ObjectConstraint> constrainedValue : this.programState.getValuesWithConstraints((Object)Status.OPENED).entrySet()) {
                ResourceWrapperSymbolicValue rValue;
                if (!(constrainedValue.getKey() instanceof ResourceWrapperSymbolicValue) || !value.equals((rValue = (ResourceWrapperSymbolicValue)constrainedValue.getKey()).dependent)) continue;
                this.programState = this.programState.addConstraint(rValue, constrainedValue.getValue().withStatus((Object)Status.CLOSED));
            }
        }

        private void closeArguments(Arguments arguments, int stackOffset) {
            List<SymbolicValue> values = this.programState.peekValues(arguments.size() + stackOffset);
            List<SymbolicValue> argumentValues = values.subList(stackOffset, values.size());
            for (SymbolicValue target : argumentValues) {
                this.closeResource(target);
            }
        }

        private void closeResource(@Nullable SymbolicValue target) {
            ObjectConstraint oConstraint;
            if (target != null && (oConstraint = this.programState.getConstraintWithStatus(target, (Object)Status.OPENED)) != null) {
                this.programState = this.programState.addConstraint(target.wrappedValue(), oConstraint.withStatus((Object)Status.CLOSED));
            }
        }

        private static boolean isClosingResource(Symbol symbol) {
            return PreStatementVisitor.isMethodMatchingName(symbol, CLOSE_METHOD_NAME);
        }

        private static boolean isClosingResultSets(Symbol symbol) {
            return PreStatementVisitor.isMethodMatchingName(symbol, GET_MORE_RESULTS_METHOD_NAME);
        }

        private static boolean isOpeningResultSet(Symbol symbol) {
            return PreStatementVisitor.isMethodMatchingName(symbol, GET_RESULT_SET);
        }

        private static boolean isMethodMatchingName(Symbol symbol, String matchName) {
            return symbol.isMethodSymbol() && matchName.equals(symbol.name());
        }
    }

    private static class WrappedValueFactory
    implements SymbolicValueFactory {
        private final SymbolicValue value;

        WrappedValueFactory(SymbolicValue value) {
            this.value = value;
        }

        @Override
        public SymbolicValue createSymbolicValue(int counter, Tree syntaxNode) {
            return new ResourceWrapperSymbolicValue(counter, this.value);
        }
    }

    private static class ResourceWrapperSymbolicValue
    extends SymbolicValue {
        private final SymbolicValue dependent;

        ResourceWrapperSymbolicValue(int id, SymbolicValue dependent) {
            super(id);
            this.dependent = dependent;
        }

        @Override
        public SymbolicValue wrappedValue() {
            return this.dependent.wrappedValue();
        }
    }

    private static enum Status {
        OPENED,
        CLOSED;

    }
}

