/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.xml;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.java.SonarComponents;
import org.sonar.java.xml.XmlCheck;
import org.sonar.java.xml.XmlCheckContextImpl;
import org.sonar.java.xml.XmlParser;
import org.sonar.java.xml.maven.PomCheck;
import org.sonar.java.xml.maven.PomCheckContextImpl;
import org.sonar.java.xml.maven.PomParser;
import org.sonar.maven.model.maven2.MavenProject;
import org.sonar.squidbridge.ProgressReport;
import org.sonar.squidbridge.api.CodeVisitor;
import org.w3c.dom.Document;

public class XmlAnalyzer {
    private static final Logger LOG = LoggerFactory.getLogger(XmlAnalyzer.class);
    private final SonarComponents sonarComponents;
    private final List<XmlCheck> xmlChecks;
    private final List<PomCheck> pomChecks;
    private final XPath xPath;

    public XmlAnalyzer(SonarComponents sonarComponents, CodeVisitor ... visitors) {
        ImmutableList.Builder xmlChecksBuilder = ImmutableList.builder();
        ImmutableList.Builder pomChecksBuilder = ImmutableList.builder();
        for (CodeVisitor visitor : visitors) {
            if (visitor instanceof XmlCheck) {
                xmlChecksBuilder.add((Object)((XmlCheck)visitor));
                continue;
            }
            if (!(visitor instanceof PomCheck)) continue;
            pomChecksBuilder.add((Object)((PomCheck)visitor));
        }
        this.xmlChecks = xmlChecksBuilder.build();
        this.pomChecks = pomChecksBuilder.build();
        this.sonarComponents = sonarComponents;
        this.xPath = XPathFactory.newInstance().newXPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scan(Iterable<File> files) {
        boolean hasChecks;
        boolean bl = hasChecks = !this.xmlChecks.isEmpty() || !this.pomChecks.isEmpty();
        if (hasChecks && Iterables.isEmpty(files)) {
            LOG.warn("No 'xml' file have been indexed.");
            return;
        }
        ProgressReport progressReport = new ProgressReport("Report about progress of Xml analyzer", TimeUnit.SECONDS.toMillis(10L));
        progressReport.start((Collection)Lists.newArrayList(files));
        boolean successfulyCompleted = false;
        try {
            for (File file : files) {
                this.simpleScan(file);
                progressReport.nextFile();
            }
            successfulyCompleted = true;
        }
        finally {
            if (successfulyCompleted) {
                progressReport.stop();
            } else {
                progressReport.cancel();
            }
        }
    }

    private void simpleScan(File file) {
        Document document = XmlParser.parseXML(file);
        if (document != null) {
            this.simpleScanAsXmlFile(file, document);
            if ("pom.xml".equals(file.getName())) {
                this.simpleScanAsPomFile(file, document);
            }
        }
    }

    private void simpleScanAsXmlFile(File file, Document document) {
        XmlCheckContextImpl context = new XmlCheckContextImpl(document, file, this.xPath, this.sonarComponents);
        for (XmlCheck check : this.xmlChecks) {
            check.scanFile(context);
        }
    }

    private void simpleScanAsPomFile(File file, Document document) {
        MavenProject project = PomParser.parseXML(file);
        if (project != null) {
            PomCheckContextImpl context = new PomCheckContextImpl(project, document, file, this.xPath, this.sonarComponents);
            for (PomCheck check : this.pomChecks) {
                check.scanFile(context);
            }
        }
    }
}

