/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.symbolicvalues;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.constraint.BooleanConstraint;
import org.sonar.java.se.constraint.Constraint;
import org.sonar.java.se.constraint.ObjectConstraint;
import org.sonar.java.se.symbolicvalues.SymbolicValue;

public abstract class BinarySymbolicValue
extends SymbolicValue {
    SymbolicValue leftOp;
    SymbolicValue rightOp;

    public BinarySymbolicValue(int id) {
        super(id);
    }

    public abstract BooleanConstraint shouldNotInverse();

    @Override
    public boolean references(SymbolicValue other) {
        return this.leftOp.equals(other) || this.rightOp.equals(other) || this.leftOp.references(other) || this.rightOp.references(other);
    }

    @Override
    public void computedFrom(List<SymbolicValue> symbolicValues) {
        Preconditions.checkArgument((symbolicValues.size() == 2 ? 1 : 0) != 0);
        if (this.rightOp == null && this.leftOp == null) {
            this.rightOp = symbolicValues.get(0);
            this.leftOp = symbolicValues.get(1);
        }
    }

    protected List<ProgramState> copyConstraint(SymbolicValue from, SymbolicValue to, ProgramState programState, BooleanConstraint booleanConstraint) {
        Constraint constraintLeft = programState.getConstraint(from);
        if (constraintLeft instanceof BooleanConstraint) {
            BooleanConstraint boolConstraint = (BooleanConstraint)constraintLeft;
            return to.setConstraint(programState, this.shouldNotInverse().equals(booleanConstraint) ? boolConstraint : boolConstraint.inverse());
        }
        if (constraintLeft instanceof ObjectConstraint) {
            ObjectConstraint objectConstraint = (ObjectConstraint)constraintLeft;
            if (objectConstraint.isNull()) {
                return to.setConstraint(programState, this.shouldNotInverse().equals(booleanConstraint) ? objectConstraint : objectConstraint.inverse());
            }
            if (this.shouldNotInverse().equals(booleanConstraint)) {
                return to.setConstraint(programState, objectConstraint);
            }
            if (objectConstraint.isInvalidWith(programState.getConstraint(to))) {
                return ImmutableList.of();
            }
        }
        return ImmutableList.of((Object)programState);
    }
}

