/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.declaration.AnnotationTreeImpl;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.ArrayDimensionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

public class ArrayDimensionTreeImpl
extends JavaTree
implements ArrayDimensionTree {
    private List<AnnotationTree> annotations = ImmutableList.of();
    private final SyntaxToken openBracketToken;
    @Nullable
    private final ExpressionTree expression;
    private final SyntaxToken closeBracketToken;

    public ArrayDimensionTreeImpl(SyntaxToken openBracketToken, @Nullable ExpressionTree expression, SyntaxToken closeBracketToken) {
        super(Tree.Kind.ARRAY_DIMENSION);
        this.openBracketToken = openBracketToken;
        this.expression = expression;
        this.closeBracketToken = closeBracketToken;
    }

    public ArrayDimensionTreeImpl(List<AnnotationTreeImpl> annotations, SyntaxToken openBracketToken, @Nullable ExpressionTree expression, SyntaxToken closeBracketToken) {
        this(openBracketToken, expression, closeBracketToken);
        this.annotations = ImmutableList.builder().addAll(annotations).build();
    }

    public ArrayDimensionTreeImpl completeAnnotations(List<AnnotationTreeImpl> annotations) {
        this.annotations = ImmutableList.builder().addAll(annotations).build();
        return this;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitArrayDimension(this);
    }

    @Override
    public List<AnnotationTree> annotations() {
        return this.annotations;
    }

    @Override
    public SyntaxToken openBracketToken() {
        return this.openBracketToken;
    }

    @Override
    @Nullable
    public ExpressionTree expression() {
        return this.expression;
    }

    @Override
    public SyntaxToken closeBracketToken() {
        return this.closeBracketToken;
    }

    @Override
    public Tree.Kind kind() {
        return Tree.Kind.ARRAY_DIMENSION;
    }

    @Override
    public Iterable<Tree> children() {
        ImmutableList.Builder iteratorBuilder = ImmutableList.builder();
        iteratorBuilder.addAll(this.annotations);
        iteratorBuilder.add((Object)this.openBracketToken);
        if (this.expression != null) {
            iteratorBuilder.add((Object)this.expression);
        }
        iteratorBuilder.add((Object)this.closeBracketToken);
        return iteratorBuilder.build();
    }
}

