/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Closeables;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.java.bytecode.ClassLoaderBuilder;
import org.sonar.java.bytecode.loader.SquidClassLoader;
import org.sonar.java.resolve.BytecodeVisitor;
import org.sonar.java.resolve.ClassJavaType;
import org.sonar.java.resolve.Convert;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.java.resolve.ParametrizedTypeCache;
import org.sonar.java.resolve.Resolve;
import org.sonar.java.resolve.Scope;
import org.sonar.java.resolve.Symbols;

public class BytecodeCompleter
implements JavaSymbol.Completer {
    private static final Logger LOG = Loggers.get(BytecodeCompleter.class);
    private static final int ACCEPTABLE_BYTECODE_FLAGS = 159743;
    private Symbols symbols;
    private final List<File> projectClasspath;
    private final ParametrizedTypeCache parametrizedTypeCache;
    private final Map<String, JavaSymbol.TypeJavaSymbol> classes = new HashMap<String, JavaSymbol.TypeJavaSymbol>();
    private final Map<String, JavaSymbol.PackageJavaSymbol> packages = new HashMap<String, JavaSymbol.PackageJavaSymbol>();
    private ClassLoader classLoader;

    public BytecodeCompleter(List<File> projectClasspath, ParametrizedTypeCache parametrizedTypeCache) {
        this.projectClasspath = projectClasspath;
        this.parametrizedTypeCache = parametrizedTypeCache;
    }

    public void init(Symbols symbols) {
        this.symbols = symbols;
    }

    public JavaSymbol.TypeJavaSymbol registerClass(JavaSymbol.TypeJavaSymbol classSymbol) {
        String flatName = this.formFullName(classSymbol);
        Preconditions.checkState((!this.classes.containsKey(flatName) ? 1 : 0) != 0, (Object)("Registering class 2 times : " + flatName));
        this.classes.put(flatName, classSymbol);
        return classSymbol;
    }

    @Override
    public void complete(JavaSymbol symbol) {
        LOG.debug("Completing symbol : " + symbol.name);
        String bytecodeName = this.formFullName(symbol);
        JavaSymbol.TypeJavaSymbol classSymbol = this.getClassSymbol(bytecodeName);
        Preconditions.checkState((classSymbol == symbol ? 1 : 0) != 0);
        InputStream inputStream = null;
        ClassReader classReader = null;
        try {
            inputStream = this.inputStreamFor(bytecodeName);
            if (inputStream != null) {
                classReader = new ClassReader(inputStream);
            }
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            Closeables.closeQuietly((InputStream)inputStream);
        }
        if (classReader != null) {
            classReader.accept((ClassVisitor)new BytecodeVisitor(this, this.symbols, (JavaSymbol.TypeJavaSymbol)symbol, this.parametrizedTypeCache), 7);
        }
    }

    @Nullable
    private InputStream inputStreamFor(String fullname) {
        return this.getClassLoader().getResourceAsStream(Convert.bytecodeName(fullname) + ".class");
    }

    private ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            this.classLoader = ClassLoaderBuilder.create(this.projectClasspath);
        }
        return this.classLoader;
    }

    public String formFullName(JavaSymbol symbol) {
        return this.formFullName(symbol.name, symbol.owner);
    }

    public String formFullName(String name, JavaSymbol site) {
        String result = name;
        for (JavaSymbol owner = site; owner != this.symbols.defaultPackage; owner = owner.owner()) {
            String separator = ".";
            if (owner.kind == 2) {
                separator = "$";
            }
            result = owner.name + separator + result;
        }
        return result;
    }

    @VisibleForTesting
    JavaSymbol.TypeJavaSymbol getClassSymbol(String bytecodeName) {
        return this.getClassSymbol(bytecodeName, 0);
    }

    JavaSymbol.TypeJavaSymbol getClassSymbol(String bytecodeName, int flags) {
        return this.getClassSymbol(null, bytecodeName, flags);
    }

    public JavaSymbol.TypeJavaSymbol getClassSymbol(@Nullable JavaSymbol.TypeJavaSymbol classSymbolOwner, String bytecodeName, int flags) {
        String flatName = Convert.flatName(bytecodeName);
        JavaSymbol.TypeJavaSymbol symbol = this.classes.get(flatName);
        if (symbol == null) {
            String enclosingClassName;
            String shortName = Convert.shortName(flatName);
            String packageName = Convert.packagePart(flatName);
            JavaSymbol.TypeJavaSymbol owner = classSymbolOwner;
            if (owner == null && StringUtils.isNotEmpty((String)(enclosingClassName = Convert.enclosingClassName(shortName)))) {
                owner = this.getClassSymbol(Convert.fullName(packageName, enclosingClassName));
            }
            symbol = owner != null ? new JavaSymbol.TypeJavaSymbol(this.filterBytecodeFlags(flags), Convert.innerClassName(Convert.shortName(owner.getFullyQualifiedName()), shortName), owner) : new JavaSymbol.TypeJavaSymbol(this.filterBytecodeFlags(flags), shortName, this.enterPackage(packageName));
            symbol.members = new Scope(symbol);
            symbol.typeParameters = new Scope(symbol);
            if (this.getClassLoader().getResource(Convert.bytecodeName(flatName) + ".class") != null) {
                symbol.completer = this;
            } else {
                LOG.warn("Class not found: " + bytecodeName);
                ((ClassJavaType)symbol.type).interfaces = ImmutableList.of();
                ((ClassJavaType)symbol.type).supertype = Symbols.unknownType;
            }
            this.classes.put(flatName, symbol);
        }
        return symbol;
    }

    public int filterBytecodeFlags(int flags) {
        return flags & 0x26FFF;
    }

    public JavaSymbol loadClass(String fullname) {
        JavaSymbol.TypeJavaSymbol symbol = this.classes.get(fullname);
        if (symbol != null) {
            return symbol;
        }
        InputStream inputStream = this.inputStreamFor(fullname);
        String bytecodeName = Convert.bytecodeName(fullname);
        if (inputStream == null) {
            return new Resolve.JavaSymbolNotFound();
        }
        try {
            ClassReader classReader = new ClassReader(inputStream);
            String className = classReader.getClassName();
            if (!className.equals(bytecodeName)) {
                Resolve.JavaSymbolNotFound javaSymbolNotFound = new Resolve.JavaSymbolNotFound();
                return javaSymbolNotFound;
            }
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            Closeables.closeQuietly((InputStream)inputStream);
        }
        return this.getClassSymbol(fullname);
    }

    public JavaSymbol.PackageJavaSymbol enterPackage(String fullname) {
        if (StringUtils.isBlank((String)fullname)) {
            return this.symbols.defaultPackage;
        }
        JavaSymbol.PackageJavaSymbol result = this.packages.get(fullname);
        if (result == null) {
            result = new JavaSymbol.PackageJavaSymbol(fullname, this.symbols.defaultPackage);
            this.packages.put(fullname, result);
        }
        return result;
    }

    public void done() {
        if (this.classLoader != null && this.classLoader instanceof SquidClassLoader) {
            ((SquidClassLoader)this.classLoader).close();
        }
    }

    static boolean isSynthetic(int flags) {
        return (flags & 0x1000) != 0;
    }
}

