/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.resolve.BytecodeCompleter;
import org.sonar.java.resolve.FirstPass;
import org.sonar.java.resolve.JavaType;
import org.sonar.java.resolve.LabelsVisitor;
import org.sonar.java.resolve.ParametrizedTypeCache;
import org.sonar.java.resolve.Resolve;
import org.sonar.java.resolve.Symbols;
import org.sonar.java.resolve.TypeAndReferenceSolver;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.ListTree;
import org.sonar.plugins.java.api.tree.Tree;

public class SemanticModel {
    private final Map<Tree, Symbol> symbolsTree = new HashMap<Tree, Symbol>();
    private final Map<Symbol, Resolve.Env> symbolEnvs = Maps.newHashMap();
    private final BiMap<Tree, Resolve.Env> envs = HashBiMap.create();
    private BytecodeCompleter bytecodeCompleter;

    private SemanticModel() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SemanticModel createFor(CompilationUnitTree tree, List<File> projectClasspath) {
        ParametrizedTypeCache parametrizedTypeCache = new ParametrizedTypeCache();
        BytecodeCompleter bytecodeCompleter = new BytecodeCompleter(projectClasspath, parametrizedTypeCache);
        Symbols symbols = new Symbols(bytecodeCompleter);
        SemanticModel semanticModel = new SemanticModel();
        semanticModel.bytecodeCompleter = bytecodeCompleter;
        try {
            Resolve resolve = new Resolve(symbols, bytecodeCompleter, parametrizedTypeCache);
            TypeAndReferenceSolver typeAndReferenceSolver = new TypeAndReferenceSolver(semanticModel, symbols, resolve, parametrizedTypeCache);
            new FirstPass(semanticModel, symbols, resolve, parametrizedTypeCache, typeAndReferenceSolver).visitCompilationUnit(tree);
            typeAndReferenceSolver.visitCompilationUnit(tree);
            new LabelsVisitor(semanticModel).visitCompilationUnit(tree);
        }
        finally {
            SemanticModel.handleMissingTypes(tree);
        }
        return semanticModel;
    }

    public void done() {
        this.bytecodeCompleter.done();
    }

    public static void handleMissingTypes(Tree tree) {
        tree.accept(new BaseTreeVisitor(){

            @Override
            protected void scan(@Nullable Tree tree) {
                AbstractTypedTree typedNode;
                if (tree instanceof AbstractTypedTree && (!(typedNode = (AbstractTypedTree)tree).isTypeSet() || ((JavaType)typedNode.symbolType()).isTagged(17))) {
                    typedNode.setType(Symbols.unknownType);
                }
                super.scan(tree);
            }

            @Override
            protected void scan(ListTree<? extends Tree> listTree) {
                if (listTree != null) {
                    this.scan((List<? extends Tree>)listTree);
                }
            }
        });
    }

    public void saveEnv(Symbol symbol, Resolve.Env env) {
        this.symbolEnvs.put(symbol, env);
    }

    public Resolve.Env getEnv(Symbol symbol) {
        return this.symbolEnvs.get(symbol);
    }

    public void associateEnv(Tree tree, Resolve.Env env) {
        this.envs.put((Object)tree, (Object)env);
    }

    public Tree getTree(Resolve.Env env) {
        return (Tree)this.envs.inverse().get((Object)env);
    }

    public Resolve.Env getEnv(Tree tree) {
        Resolve.Env result = null;
        for (Tree node = tree; result == null && node != null; node = node.parent()) {
            result = (Resolve.Env)this.envs.get((Object)node);
        }
        return result;
    }

    public Symbol getEnclosingClass(Tree tree) {
        return this.getEnv((Tree)tree).enclosingClass;
    }

    public void associateSymbol(Tree tree, Symbol symbol) {
        Preconditions.checkNotNull((Object)symbol);
        this.symbolsTree.put(tree, symbol);
    }

    @Nullable
    public Symbol getSymbol(Tree tree) {
        return this.symbolsTree.get(tree);
    }

    @VisibleForTesting
    Map<Tree, Symbol> getSymbolsTree() {
        return Collections.unmodifiableMap(this.symbolsTree);
    }
}

