/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.issue.Issuable;
import org.sonar.api.rule.RuleKey;

public final class CompIssue {
    private static final Reflection SQ_5_2 = Reflection.create();
    private final InputFile inputFile;
    private final Issuable issuable;
    private final Issuable.IssueBuilder issueBuilder;
    @Nullable
    private List<Object> secondaryLocations;

    public static CompIssue create(InputFile inputFile, Issuable issuable, RuleKey ruleKey, @Nullable Double effortToFix) {
        Issuable.IssueBuilder issueBuilder = issuable.newIssueBuilder().ruleKey(ruleKey).effortToFix(effortToFix);
        return new CompIssue(issuable, issueBuilder, inputFile);
    }

    public CompIssue(Issuable issuable, Issuable.IssueBuilder issueBuilder, InputFile inputFile) {
        this.issuable = issuable;
        this.issueBuilder = issueBuilder;
        this.inputFile = inputFile;
    }

    public CompIssue setPrimaryLocation(String message, @Nullable Integer line) {
        if (SQ_5_2 == null) {
            this.issueBuilder.line(line).message(message);
            return this;
        }
        try {
            Object range = line == null ? null : SQ_5_2.inputFile_selectLine.invoke((Object)this.inputFile, line);
            this.setPrimaryLocation(message, range);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw Throwables.propagate((Throwable)e);
        }
        return this;
    }

    public CompIssue setPrimaryLocation(String message, int startLine, int startLineOffset, int endLine, int endLineOffset) {
        if (SQ_5_2 == null) {
            this.issueBuilder.line(Integer.valueOf(startLine)).message(message);
            return this;
        }
        try {
            Object range = startLineOffset != -1 ? SQ_5_2.inputFile_newRange.invoke((Object)this.inputFile, startLine, startLineOffset, endLine, endLineOffset) : SQ_5_2.inputFile_selectLine.invoke((Object)this.inputFile, startLine);
            this.setPrimaryLocation(message, range);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw Throwables.propagate((Throwable)e);
        }
        return this;
    }

    public CompIssue addSecondaryLocation(int startLine, int startLineOffset, int endLine, int endLineOffset, String message) {
        if (SQ_5_2 == null) {
            return this;
        }
        try {
            Object newLocation = SQ_5_2.issueBuilder_newLocation.invoke((Object)this.issueBuilder, new Object[0]);
            SQ_5_2.newIssueLocation_on.invoke(newLocation, this.inputFile);
            Object range = SQ_5_2.inputFile_newRange.invoke((Object)this.inputFile, startLine, startLineOffset, endLine, endLineOffset);
            SQ_5_2.newIssueLocation_at.invoke(newLocation, range);
            SQ_5_2.newIssueLocation_message.invoke(newLocation, message);
            if (this.secondaryLocations == null) {
                this.secondaryLocations = new ArrayList<Object>();
            }
            this.secondaryLocations.add(newLocation);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw Throwables.propagate((Throwable)e);
        }
        return this;
    }

    private void setPrimaryLocation(String message, @Nullable Object range) throws InvocationTargetException, IllegalAccessException {
        Object newLocation = SQ_5_2.issueBuilder_newLocation.invoke((Object)this.issueBuilder, new Object[0]);
        SQ_5_2.newIssueLocation_on.invoke(newLocation, this.inputFile);
        if (range != null) {
            SQ_5_2.newIssueLocation_at.invoke(newLocation, range);
        }
        SQ_5_2.newIssueLocation_message.invoke(newLocation, message);
        SQ_5_2.issueBuilder_at.invoke((Object)this.issueBuilder, newLocation);
    }

    public void save() {
        if (this.secondaryLocations != null) {
            try {
                for (Object secondaryLocation : this.secondaryLocations) {
                    SQ_5_2.issueBuilder_addFlow.invoke((Object)this.issueBuilder, ImmutableList.of((Object)secondaryLocation));
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        this.issuable.addIssue(this.issueBuilder.build());
    }

    static {
        if (SQ_5_2 != null) {
            LoggerFactory.getLogger(CompIssue.class).warn(">>> Enabled usage of SonarQube 5.2 BETA APIs <<<");
        }
    }

    private static class Reflection {
        private final Method inputFile_newRange;
        private final Method inputFile_selectLine;
        private final Method newIssueLocation_on;
        private final Method newIssueLocation_at;
        private final Method newIssueLocation_message;
        private final Method issueBuilder_at;
        private final Method issueBuilder_newLocation;
        private final Method issueBuilder_addFlow;

        public static Reflection create() {
            try {
                return new Reflection();
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                return null;
            }
        }

        public Reflection() throws ClassNotFoundException, NoSuchMethodException {
            Class<?> classTextRange = Class.forName("org.sonar.api.batch.fs.TextRange");
            Class<?> classInputComponent = Class.forName("org.sonar.api.batch.fs.InputComponent");
            Class<?> classNewIssueLocation = Class.forName("org.sonar.api.batch.sensor.issue.NewIssueLocation");
            this.inputFile_selectLine = Reflection.method(InputFile.class, "selectLine", Integer.TYPE);
            this.inputFile_newRange = Reflection.method(InputFile.class, "newRange", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            this.issueBuilder_at = Reflection.method(Issuable.IssueBuilder.class, "at", classNewIssueLocation);
            this.issueBuilder_newLocation = Reflection.method(Issuable.IssueBuilder.class, "newLocation", new Class[0]);
            this.issueBuilder_addFlow = Reflection.method(Issuable.IssueBuilder.class, "addFlow", Iterable.class);
            this.newIssueLocation_on = Reflection.method(classNewIssueLocation, "on", classInputComponent);
            this.newIssueLocation_at = Reflection.method(classNewIssueLocation, "at", classTextRange);
            this.newIssueLocation_message = Reflection.method(classNewIssueLocation, "message", String.class);
        }

        private static Method method(Class<?> cls, String name, Class<?> ... parameterTypes) throws NoSuchMethodException {
            Method method = cls.getMethod(name, parameterTypes);
            method.setAccessible(true);
            return method;
        }
    }
}

