/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.design.Dependency;
import org.sonar.api.resources.Resource;
import org.sonar.api.utils.TimeProfiler;
import org.sonar.graph.DirectedGraph;
import org.sonar.java.JavaConfiguration;
import org.sonar.java.Measurer;
import org.sonar.java.SonarComponents;
import org.sonar.java.ast.JavaAstScanner;
import org.sonar.java.ast.parser.JavaParser;
import org.sonar.java.ast.visitors.FileLinesVisitor;
import org.sonar.java.ast.visitors.SyntaxHighlighterVisitor;
import org.sonar.java.bytecode.BytecodeScanner;
import org.sonar.java.bytecode.visitor.DefaultBytecodeContext;
import org.sonar.java.bytecode.visitor.DependenciesVisitor;
import org.sonar.java.model.InternalVisitorsBridge;
import org.sonar.plugins.java.api.JavaResourceLocator;
import org.sonar.squidbridge.api.CodeVisitor;
import org.sonar.squidbridge.api.Query;
import org.sonar.squidbridge.api.SourceCode;
import org.sonar.squidbridge.api.SourceCodeSearchEngine;
import org.sonar.squidbridge.indexer.SquidIndex;

public class JavaSquid
implements SourceCodeSearchEngine {
    private static final Logger LOG = LoggerFactory.getLogger(JavaSquid.class);
    private final SquidIndex squidIndex;
    private final JavaAstScanner astScanner;
    private final JavaAstScanner astScannerForTests;
    private final BytecodeScanner bytecodeScanner;
    private final DirectedGraph<Resource, Dependency> graph = new DirectedGraph();
    private boolean bytecodeScanned = false;

    public JavaSquid(JavaConfiguration conf, @Nullable SonarComponents sonarComponents, @Nullable Measurer measurer, JavaResourceLocator javaResourceLocator, CodeVisitor ... visitors) {
        Iterable codeVisitors = Iterables.concat(Collections.singletonList(javaResourceLocator), Arrays.asList(visitors));
        if (measurer != null) {
            List<Measurer> measurers = Collections.singletonList(measurer);
            codeVisitors = Iterables.concat(measurers, (Iterable)codeVisitors);
        }
        List<Object> classpath = Lists.newArrayList();
        List<Object> testClasspath = Lists.newArrayList();
        ArrayList testCodeVisitors = Lists.newArrayList((Object[])new CodeVisitor[]{javaResourceLocator});
        if (sonarComponents != null) {
            codeVisitors = Iterables.concat((Iterable)codeVisitors, Arrays.asList(new FileLinesVisitor(sonarComponents, conf.getCharset()), new SyntaxHighlighterVisitor(sonarComponents, conf.getCharset())));
            testCodeVisitors.add(new SyntaxHighlighterVisitor(sonarComponents, conf.getCharset()));
            classpath = sonarComponents.getJavaClasspath();
            testClasspath = sonarComponents.getJavaTestClasspath();
            testCodeVisitors.addAll(sonarComponents.testCheckClasses());
        }
        this.astScanner = new JavaAstScanner(JavaParser.createParser(conf.getCharset()));
        this.astScanner.setVisitorBridge(JavaSquid.createVisitorBridge(codeVisitors, classpath, conf, sonarComponents));
        this.astScannerForTests = new JavaAstScanner(this.astScanner);
        this.astScannerForTests.setVisitorBridge(JavaSquid.createVisitorBridge(testCodeVisitors, testClasspath, conf, sonarComponents));
        DefaultBytecodeContext bytecodeContext = new DefaultBytecodeContext(sonarComponents, javaResourceLocator);
        this.bytecodeScanner = new BytecodeScanner(bytecodeContext);
        DependenciesVisitor dependenciesVisitor = new DependenciesVisitor(bytecodeContext, this.graph);
        this.bytecodeScanner.accept(dependenciesVisitor);
        for (CodeVisitor visitor : visitors) {
            this.bytecodeScanner.accept(visitor);
        }
        this.squidIndex = (SquidIndex)this.astScanner.getIndex();
    }

    private static InternalVisitorsBridge createVisitorBridge(Iterable<CodeVisitor> codeVisitors, List<File> classpath, JavaConfiguration conf, @Nullable SonarComponents sonarComponents) {
        InternalVisitorsBridge visitorsBridge = new InternalVisitorsBridge(codeVisitors, classpath, sonarComponents);
        visitorsBridge.setCharset(conf.getCharset());
        visitorsBridge.setAnalyseAccessors(conf.separatesAccessorsFromMethods());
        visitorsBridge.setJavaVersion(conf.javaVersion());
        return visitorsBridge;
    }

    public void scan(Iterable<File> sourceFiles, Iterable<File> testFiles, Collection<File> bytecodeFilesOrDirectories) {
        this.scanSources(sourceFiles);
        this.scanBytecode(bytecodeFilesOrDirectories);
        this.scanTests(testFiles);
    }

    private void scanSources(Iterable<File> sourceFiles) {
        TimeProfiler profiler = new TimeProfiler(this.getClass()).start("Java Main Files AST scan");
        this.astScanner.scan(sourceFiles);
        profiler.stop();
    }

    private void scanTests(Iterable<File> testFiles) {
        TimeProfiler profiler = new TimeProfiler(this.getClass()).start("Java Test Files AST scan");
        this.astScannerForTests.simpleScan(testFiles);
        profiler.stop();
    }

    private void scanBytecode(Collection<File> bytecodeFilesOrDirectories) {
        if (JavaSquid.hasBytecode(bytecodeFilesOrDirectories)) {
            TimeProfiler profiler = new TimeProfiler(this.getClass()).start("Java bytecode scan");
            this.bytecodeScanner.scan(bytecodeFilesOrDirectories);
            this.bytecodeScanned = true;
            profiler.stop();
        } else {
            LOG.warn("Java bytecode has not been made available to the analyzer. The " + Joiner.on((String)", ").join((Iterable)this.bytecodeScanner.getVisitors()) + " are disabled.");
            this.bytecodeScanned = false;
        }
    }

    static boolean hasBytecode(Collection<File> bytecodeFilesOrDirectories) {
        if (bytecodeFilesOrDirectories == null) {
            return false;
        }
        for (File bytecodeFilesOrDirectory : bytecodeFilesOrDirectories) {
            if (!bytecodeFilesOrDirectory.exists() || !bytecodeFilesOrDirectory.isFile() && FileUtils.listFiles((File)bytecodeFilesOrDirectory, (String[])new String[]{"class"}, (boolean)true).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean isBytecodeScanned() {
        return this.bytecodeScanned;
    }

    public SquidIndex getIndex() {
        return this.squidIndex;
    }

    public DirectedGraph<Resource, Dependency> getGraph() {
        return this.graph;
    }

    public SourceCode search(String key) {
        return this.squidIndex.search(key);
    }

    public Collection<SourceCode> search(Query ... query) {
        return this.squidIndex.search(query);
    }
}

